/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import org.jboss.as.cli.CliInitializationException;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandContextFactory;
import org.jboss.as.test.integration.management.util.SecurityActions;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.junit.Assert;

public class CLITestUtil {
    private static final String JBOSS_CLI_CONFIG = "jboss.cli.config";
    private static final String JREADLINE_TERMINAL = "jreadline.terminal";
    private static final String JREADLINE_TEST_TERMINAL = "org.jboss.jreadline.terminal.TestTerminal";
    private static final String serverAddr = TestSuiteEnvironment.getServerAddress();
    private static final int serverPort = TestSuiteEnvironment.getServerPort();

    public static CommandContext getCommandContext() throws CliInitializationException {
        CLITestUtil.setJBossCliConfig();
        return CommandContextFactory.getInstance().newCommandContext("http-remoting", serverAddr, serverPort, null, null);
    }

    public static CommandContext getCommandContext(String address, int port, InputStream in, OutputStream out) throws CliInitializationException {
        CLITestUtil.setJBossCliConfig();
        return CommandContextFactory.getInstance().newCommandContext(address, port, null, null, in, out);
    }

    public static CommandContext getCommandContext(OutputStream out) throws CliInitializationException {
        SecurityActions.setSystemProperty(JREADLINE_TERMINAL, JREADLINE_TEST_TERMINAL);
        CLITestUtil.setJBossCliConfig();
        return CommandContextFactory.getInstance().newCommandContext(serverAddr, serverPort, null, null, null, out);
    }

    protected static void setJBossCliConfig() {
        String jbossCliConfig = SecurityActions.getSystemProperty(JBOSS_CLI_CONFIG);
        if (jbossCliConfig == null) {
            String jbossDist = System.getProperty("jboss.dist");
            if (jbossDist == null) {
                Assert.fail((String)"jboss.dist system property is not set");
            }
            SecurityActions.setSystemProperty(JBOSS_CLI_CONFIG, jbossDist + File.separator + "bin" + File.separator + "jboss-cli.xml");
        }
    }
}

