/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.util.AvailablePortFinder;
import org.jboss.as.test.integration.security.common.ExtCreateKdcServer;

public class KDCServerAnnotationProcessor {
    public static KdcServer getKdcServer(DirectoryService directoryService, int startPort, String address) throws Exception {
        ExtCreateKdcServer createKdcServer = (ExtCreateKdcServer)AnnotationUtils.getInstance(ExtCreateKdcServer.class);
        return KDCServerAnnotationProcessor.createKdcServer(createKdcServer, directoryService, startPort, address);
    }

    private static KdcServer createKdcServer(ExtCreateKdcServer createKdcServer, DirectoryService directoryService, int startPort, String bindAddress) {
        if (createKdcServer == null) {
            return null;
        }
        KdcServer kdcServer = new KdcServer();
        kdcServer.setServiceName(createKdcServer.name());
        kdcServer.setKdcPrincipal(createKdcServer.kdcPrincipal());
        kdcServer.setPrimaryRealm(createKdcServer.primaryRealm());
        kdcServer.setMaximumTicketLifetime(createKdcServer.maxTicketLifetime());
        kdcServer.setMaximumRenewableLifetime(createKdcServer.maxRenewableLifetime());
        kdcServer.setSearchBaseDn(createKdcServer.searchBaseDn());
        kdcServer.setPaEncTimestampRequired(false);
        CreateTransport[] transportBuilders = createKdcServer.transports();
        if (transportBuilders == null) {
            UdpTransport defaultTransport = new UdpTransport(AvailablePortFinder.getNextAvailable((int)startPort));
            kdcServer.addTransports(new Transport[]{defaultTransport});
        } else if (transportBuilders.length > 0) {
            for (CreateTransport transportBuilder : transportBuilders) {
                String address;
                String protocol = transportBuilder.protocol();
                int port = transportBuilder.port();
                int nbThreads = transportBuilder.nbThreads();
                int backlog = transportBuilder.backlog();
                String string = address = bindAddress != null ? bindAddress : transportBuilder.address();
                if (port == -1) {
                    port = AvailablePortFinder.getNextAvailable((int)startPort);
                    startPort = port + 1;
                }
                if (protocol.equalsIgnoreCase("TCP")) {
                    TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
                    kdcServer.addTransports(new Transport[]{tcp});
                    continue;
                }
                if (protocol.equalsIgnoreCase("UDP")) {
                    UdpTransport udp = new UdpTransport(address, port);
                    kdcServer.addTransports(new Transport[]{udp});
                    continue;
                }
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
            }
        }
        kdcServer.setDirectoryService(directoryService);
        try {
            kdcServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return kdcServer;
    }
}

