/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.interfaces;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.StandardHttpRequestRetryHandler;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.util.EntityUtils;
import org.jboss.as.test.integration.management.interfaces.ManagementInterface;
import org.jboss.dmr.ModelNode;

public class HttpManagementInterface
implements ManagementInterface {
    public static final String MANAGEMENT_REALM = "ManagementRealm";
    private final URI uri;
    private final HttpClient httpClient;

    public HttpManagementInterface(String uriScheme, String host, int port, String username, String password) {
        try {
            this.uri = new URI(uriScheme + "://" + host + ":" + port + "/management");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.httpClient = HttpManagementInterface.createHttpClient(host, port, username, password);
    }

    @Override
    public ModelNode execute(ModelNode operation) {
        String operationJson = operation.toJSONString(true);
        try {
            HttpPost post = new HttpPost(this.uri);
            post.setEntity((HttpEntity)new StringEntity(operationJson, ContentType.APPLICATION_JSON));
            post.setHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            HttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return this.parseResponse(response);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode parseResponse(HttpResponse response) {
        try {
            ModelNode modelResponse;
            String content = EntityUtils.toString((HttpEntity)response.getEntity());
            int status = response.getStatusLine().getStatusCode();
            if (status == 200) {
                modelResponse = ModelNode.fromJSONString((String)content);
            } else {
                modelResponse = new ModelNode();
                modelResponse.get("outcome").set("failed");
                modelResponse.get("failure-description").set(content);
            }
            return modelResponse;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read response content as String");
        }
    }

    @Override
    public void close() {
        this.httpClient.getConnectionManager().shutdown();
    }

    private static HttpClient createHttpClient(String host, int port, String username, String password) {
        PoolingClientConnectionManager connectionPool = new PoolingClientConnectionManager();
        DefaultHttpClient httpClient = new DefaultHttpClient((ClientConnectionManager)connectionPool);
        SchemeRegistry schemeRegistry = httpClient.getConnectionManager().getSchemeRegistry();
        schemeRegistry.register(new Scheme("http", 80, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
        try {
            schemeRegistry.register(new Scheme("https", 443, (SchemeSocketFactory)new SSLSocketFactory(new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }, (X509HostnameVerifier)new AllowAllHostnameVerifier())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new StandardHttpRequestRetryHandler(5, true));
        httpClient.getCredentialsProvider().setCredentials(new AuthScope(host, port, MANAGEMENT_REALM, "Digest"), (Credentials)new UsernamePasswordCredentials(username, password));
        return httpClient;
    }

    public static ManagementInterface create(String host, int port, String username, String password) {
        return new HttpManagementInterface("http", host, port, username, password);
    }

    public static ManagementInterface createSecure(String host, int port, String username, String password) {
        return new HttpManagementInterface("https", host, port, username, password);
    }
}

