/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashMap;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.lang.SystemUtils;

public class Krb5LoginConfiguration
extends Configuration {
    private final AppConfigurationEntry[] configList = new AppConfigurationEntry[1];

    public Krb5LoginConfiguration() throws MalformedURLException {
        this(null, null, false);
    }

    public Krb5LoginConfiguration(String principal, File keyTab, boolean acceptor) throws MalformedURLException {
        String loginModule;
        HashMap<String, String> options = new HashMap<String, String>();
        if (SystemUtils.JAVA_VENDOR.startsWith("IBM")) {
            loginModule = "com.ibm.security.auth.module.Krb5LoginModule";
            if (keyTab != null) {
                options.put("useKeytab", keyTab.toURI().toString());
            }
            if (acceptor) {
                options.put("credsType", "acceptor");
            } else {
                options.put("noAddress", "true");
            }
        } else {
            loginModule = "com.sun.security.auth.module.Krb5LoginModule";
            if (keyTab != null) {
                options.put("keyTab", keyTab.getAbsolutePath());
                options.put("doNotPrompt", "true");
                options.put("useKeyTab", "true");
            }
            if (acceptor) {
                options.put("storeKey", "true");
            }
        }
        options.put("refreshKrb5Config", "true");
        options.put("debug", "true");
        if (principal != null) {
            options.put("principal", principal);
        }
        this.configList[0] = new AppConfigurationEntry(loginModule, AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, options);
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String applicationName) {
        return this.configList;
    }
}

