/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config;

import java.util.HashMap;
import java.util.Map;

public class AuthnModule {
    private final String name;
    private final String flag;
    private final Map<String, String> options;
    private final String loginModuleStackRef;
    private final String module;

    private AuthnModule(Builder builder) {
        this.name = builder.name;
        this.flag = builder.flag;
        this.options = builder.options;
        this.loginModuleStackRef = builder.loginModuleStackRef;
        this.module = builder.module;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public String getModule() {
        return this.module;
    }

    public String getName() {
        return this.name;
    }

    public String getFlag() {
        return this.flag;
    }

    public String getLoginModuleStackRef() {
        return this.loginModuleStackRef;
    }

    public static class Builder {
        private String name;
        private String flag;
        private Map<String, String> options;
        private String loginModuleStackRef;
        private String module;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder flag(String flag) {
            this.flag = flag;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder putOption(String name, String value) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(name, value);
            return this;
        }

        public Builder loginModuleStackRef(String loginModuleStackRef) {
            this.loginModuleStackRef = loginModuleStackRef;
            return this;
        }

        public Builder module(String module) {
            this.module = module;
            return this;
        }

        public AuthnModule build() {
            return new AuthnModule(this);
        }
    }
}

