/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.interfaces;

import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.integration.management.interfaces.ManagementInterface;
import org.jboss.as.test.integration.management.rbac.RbacAdminCallbackHandler;
import org.jboss.dmr.ModelNode;

public class NativeManagementInterface
implements ManagementInterface {
    private static final Map<String, String> SASL_OPTIONS = Collections.singletonMap("SASL_DISALLOWED_MECHANISMS", "JBOSS-LOCAL-USER");
    private final ModelControllerClient client;

    public NativeManagementInterface(ModelControllerClient client) {
        this.client = client;
    }

    @Override
    public ModelNode execute(ModelNode operation) {
        try {
            return this.client.execute(operation);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ManagementInterface create(String host, int port, String username, String password) {
        try {
            ModelControllerClient client = ModelControllerClient.Factory.create((String)host, (int)port, (CallbackHandler)new RbacAdminCallbackHandler(username, password), SASL_OPTIONS);
            return new NativeManagementInterface(client);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

