/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.as.test.integration.security.common.config.DataSource;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractDataSourceServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractDataSourceServerSetupTask.class);
    private static final String SUBSYSTEM_DATASOURCES = "datasources";
    private static final String DATASOURCE = "data-source";

    public final void setup(ManagementClient managementClient, String containerId) throws Exception {
        DataSource[] dataSourceConfigurations = this.getDataSourceConfigurations(managementClient, containerId);
        if (dataSourceConfigurations == null) {
            LOGGER.warn((Object)"Null DataSourceConfiguration array provided");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (DataSource config : dataSourceConfigurations) {
            String name = config.getName();
            LOGGER.info((Object)("Adding datasource " + name));
            ModelNode dsNode = new ModelNode();
            dsNode.get("operation").set("add");
            dsNode.get("address").add("subsystem", SUBSYSTEM_DATASOURCES);
            dsNode.get("address").add(DATASOURCE, name);
            dsNode.get("connection-url").set(config.getConnectionUrl());
            dsNode.get("jndi-name").set(config.getJndiName());
            dsNode.get("driver-name").set(config.getDriver());
            dsNode.get("enabled").set("false");
            if (StringUtils.isNotEmpty((String)config.getUsername())) {
                dsNode.get("user-name").set(config.getUsername());
            }
            if (StringUtils.isNotEmpty((String)config.getPassword())) {
                dsNode.get("password").set(config.getPassword());
            }
            updates.add(dsNode);
            ModelNode enableNode = new ModelNode();
            enableNode.get("operation").set("enable");
            enableNode.get("address").add("subsystem", SUBSYSTEM_DATASOURCES);
            enableNode.get("address").add(DATASOURCE, name);
            updates.add(enableNode);
        }
        Utils.applyUpdates(updates, managementClient.getControllerClient());
    }

    public final void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        DataSource[] dataSourceConfigurations = this.getDataSourceConfigurations(managementClient, containerId);
        if (dataSourceConfigurations == null) {
            LOGGER.warn((Object)"Null DataSourceConfiguration array provided");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        for (DataSource config : dataSourceConfigurations) {
            String name = config.getName();
            LOGGER.info((Object)("Removing datasource " + name));
            ModelNode op = new ModelNode();
            op.get("operation").set("remove");
            op.get("address").add("subsystem", SUBSYSTEM_DATASOURCES);
            op.get("address").add(DATASOURCE, name);
            updates.add(op);
        }
        Utils.applyUpdates(updates, managementClient.getControllerClient());
    }

    protected DataSource[] getDataSourceConfigurations(ManagementClient managementClient, String containerId) {
        return null;
    }
}

