/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.as.test.integration.security.common.config.realm.Authentication;
import org.jboss.as.test.integration.security.common.config.realm.Authorization;
import org.jboss.as.test.integration.security.common.config.realm.LdapAuthentication;
import org.jboss.as.test.integration.security.common.config.realm.RealmKeystore;
import org.jboss.as.test.integration.security.common.config.realm.SecurityRealm;
import org.jboss.as.test.integration.security.common.config.realm.ServerIdentity;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public abstract class AbstractSecurityRealmsServerSetupTask
implements ServerSetupTask {
    private static final Logger LOGGER = Logger.getLogger(AbstractSecurityRealmsServerSetupTask.class);
    private static final String KEYSTORE_PATH = "keystore-path";
    protected ManagementClient managementClient;
    private SecurityRealm[] securityRealms;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.managementClient = managementClient;
        this.setup(managementClient.getControllerClient(), containerId);
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        this.tearDown(managementClient.getControllerClient(), containerId);
        this.managementClient = null;
    }

    protected void setup(ModelControllerClient modelControllerClient, String containerId) throws Exception {
        this.securityRealms = this.getSecurityRealms();
        if (this.securityRealms == null || this.securityRealms.length == 0) {
            LOGGER.warn((Object)"Empty security realm configuration.");
            return;
        }
        LinkedList<ModelNode> updates = new LinkedList<ModelNode>();
        for (SecurityRealm securityRealm : this.securityRealms) {
            Authorization authorization;
            Authentication authentication;
            String securityRealmName = securityRealm.getName();
            LOGGER.info((Object)("Adding security realm " + securityRealmName));
            ModelNode compositeOp = new ModelNode();
            compositeOp.get("operation").set("composite");
            compositeOp.get("address").setEmptyList();
            ModelNode steps = compositeOp.get("steps");
            PathAddress realmAddr = this.getBaseAddress().append("core-service", "management").append("security-realm", securityRealmName);
            ModelNode op = Util.createAddOperation((PathAddress)realmAddr);
            steps.add(op);
            ServerIdentity serverIdentity = securityRealm.getServerIdentity();
            if (serverIdentity != null) {
                RealmKeystore ssl;
                if (StringUtils.isNotEmpty((String)serverIdentity.getSecret())) {
                    ModelNode secretModuleNode = Util.createAddOperation((PathAddress)realmAddr.append("server-identity", "secret"));
                    secretModuleNode.get("value").set(serverIdentity.getSecret());
                    secretModuleNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                    steps.add(secretModuleNode);
                }
                if ((ssl = serverIdentity.getSsl()) != null) {
                    ModelNode sslModuleNode = Util.createAddOperation((PathAddress)realmAddr.append("server-identity", "ssl"));
                    sslModuleNode.get(KEYSTORE_PATH).set(ssl.getKeystorePath());
                    sslModuleNode.get("keystore-password").set(ssl.getKeystorePassword());
                    sslModuleNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                    steps.add(sslModuleNode);
                }
            }
            if ((authentication = securityRealm.getAuthentication()) != null) {
                LdapAuthentication ldap;
                RealmKeystore truststore = authentication.getTruststore();
                if (truststore != null) {
                    ModelNode sslModuleNode = Util.createAddOperation((PathAddress)realmAddr.append("authentication", "truststore"));
                    sslModuleNode.get(KEYSTORE_PATH).set(truststore.getKeystorePath());
                    sslModuleNode.get("keystore-password").set(truststore.getKeystorePassword());
                    sslModuleNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                    steps.add(sslModuleNode);
                }
                if ((ldap = authentication.getLdap()) != null) {
                    PathAddress ldapConnectionAddr = this.getBaseAddress().append("core-service", "management").append("ldap-connection", ldap.getConnection());
                    ModelNode ldapConnectionNode = Util.createAddOperation((PathAddress)ldapConnectionAddr);
                    this.setModelAttribute(ldapConnectionNode, "search-dn", ldap.getSearchDn());
                    this.setModelAttribute(ldapConnectionNode, "search-credential", ldap.getSearchCredential());
                    this.setModelAttribute(ldapConnectionNode, "security-realm", ldap.getSecurityRealm());
                    this.setModelAttribute(ldapConnectionNode, "url", ldap.getUrl());
                    this.setModelAttribute(ldapConnectionNode, "initial-context-factory", ldap.getInitialContextFactory());
                    ldapConnectionNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                    steps.add(ldapConnectionNode);
                    ModelNode ldapNode = Util.createAddOperation((PathAddress)realmAddr.append("authentication", "ldap"));
                    this.setModelAttribute(ldapNode, "connection", ldap.getConnection());
                    this.setModelAttribute(ldapNode, "advanced-filter", ldap.getAdvancedFilter());
                    this.setModelAttribute(ldapNode, "base-dn", ldap.getBaseDn());
                    this.setModelAttribute(ldapNode, "user-dn", ldap.getUserDn());
                    this.setModelAttribute(ldapNode, "recursive", ldap.getRecursive());
                    this.setModelAttribute(ldapNode, "username-attribute", ldap.getUsernameAttribute());
                    this.setModelAttribute(ldapNode, "allow-empty-passwords", ldap.getAllowEmptyPasswords());
                    ldapNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                    steps.add(ldapNode);
                }
            }
            if ((authorization = securityRealm.getAuthorization()) != null) {
                ModelNode authorizationNode = Util.createAddOperation((PathAddress)realmAddr.append("authorization", "properties"));
                this.setModelAttribute(authorizationNode, "path", authorization.getPath());
                this.setModelAttribute(authorizationNode, "relative-to", authorization.getRelativeTo());
                authorizationNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
                steps.add(authorizationNode);
            }
            updates.add(compositeOp);
        }
        Utils.applyUpdates(updates, modelControllerClient);
    }

    protected void tearDown(ModelControllerClient modelControllerClient, String containerId) throws Exception {
        if (this.securityRealms == null || this.securityRealms.length == 0) {
            LOGGER.warn((Object)"Empty security realms configuration.");
            return;
        }
        ArrayList<ModelNode> updates = new ArrayList<ModelNode>();
        List<SecurityRealm> realmsToRemove = Arrays.asList(this.securityRealms);
        Collections.reverse(realmsToRemove);
        for (SecurityRealm securityRealm : realmsToRemove) {
            String realmName = securityRealm.getName();
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("Removing security realm " + realmName));
            }
            ModelNode op = Util.createRemoveOperation((PathAddress)this.getBaseAddress().append("core-service", "management").append("security-realm", realmName));
            op.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            updates.add(op);
            Authentication authentication = securityRealm.getAuthentication();
            if (authentication == null || authentication.getLdap() == null) continue;
            ModelNode ldapOp = Util.createRemoveOperation((PathAddress)this.getBaseAddress().append("core-service", "management").append("ldap-connection", authentication.getLdap().getConnection()));
            ldapOp.get(new String[]{"operation-headers", "rollback-on-runtime-failure"}).set(false);
            ldapOp.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
            updates.add(ldapOp);
        }
        Utils.applyUpdates(updates, modelControllerClient);
        this.securityRealms = null;
    }

    protected PathAddress getBaseAddress() {
        return PathAddress.EMPTY_ADDRESS;
    }

    protected abstract SecurityRealm[] getSecurityRealms() throws Exception;

    private void setModelAttribute(ModelNode node, String attribute, String value) {
        if (value != null) {
            node.get(attribute).set(value);
        }
    }

    private void setModelAttribute(ModelNode node, String attribute, Boolean value) {
        if (value != null) {
            node.get(attribute).set(value.booleanValue());
        }
    }
}

