/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import org.jboss.as.arquillian.api.ServerSetupTask;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.security.vault.VaultSession;
import org.jboss.as.test.integration.security.common.Utils;
import org.jboss.as.test.integration.security.common.VaultHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class BasicVaultServerSetupTask
implements ServerSetupTask {
    private static Logger LOGGER = Logger.getLogger(BasicVaultServerSetupTask.class);
    private ModelNode originalVault;
    private VaultSession nonInteractiveSession;
    public static final String ATTRIBUTE_NAME = "someAttributeName";
    public static final String VAULT_BLOCK = "someVaultBlock";
    public static final String VAULT_ATTRIBUTE = "secretValue";
    public static final String VAULTED_PROPERTY = "${VAULT::someVaultBlock::someAttributeName::1}";
    public static final String VAULT_PASSWORD = "VaultPassword";
    public static final String VAULT_ALIAS = "VaultAlias";
    static final String RESOURCE_LOCATION = "";
    static final String ENC_DAT_FILE = "ENC.dat";
    static final String SHARED_DAT_FILE = "Shared.dat";
    static final String VAULT_DAT_FILE = "VAULT.dat";
    static final PathAddress VAULT_PATH = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("core-service", "vault");
    private VaultHandler vaultHandler;

    public void setup(ManagementClient managementClient, String containerId) throws Exception {
        this.clean();
        this.vaultHandler = new VaultHandler("myVault.keystore", VAULT_PASSWORD, null, RESOURCE_LOCATION, 128, VAULT_ALIAS, "87654321", 20);
        ModelNode op = new ModelNode();
        LOGGER.info((Object)"Saving original vault setting");
        op = Util.getReadAttributeOperation((PathAddress)VAULT_PATH, (String)"vault-options");
        this.originalVault = managementClient.getControllerClient().execute(new OperationBuilder(op).build()).get("result");
        if (this.originalVault.get("KEYSTORE_URL") != null && this.originalVault.hasDefined("KEYSTORE_URL")) {
            op = Util.createRemoveOperation((PathAddress)VAULT_PATH);
            Utils.applyUpdate(op, managementClient.getControllerClient());
        }
        LOGGER.info((Object)"Creating new vault");
        String keystoreURL = this.vaultHandler.getKeyStore();
        String encryptionDirectory = new File(RESOURCE_LOCATION).getAbsolutePath();
        String salt = "87654321";
        int iterationCount = 20;
        this.nonInteractiveSession = new VaultSession(keystoreURL, VAULT_PASSWORD, encryptionDirectory, salt, iterationCount);
        this.nonInteractiveSession.startVaultSession(VAULT_ALIAS);
        LOGGER.info((Object)"Inserting attribute secretValue to vault");
        this.nonInteractiveSession.addSecuredAttribute(VAULT_BLOCK, ATTRIBUTE_NAME, VAULT_ATTRIBUTE.toCharArray());
        op = Util.createAddOperation((PathAddress)VAULT_PATH);
        ModelNode vaultOption = op.get("vault-options");
        vaultOption.get("KEYSTORE_URL").set(keystoreURL);
        vaultOption.get("KEYSTORE_PASSWORD").set(this.nonInteractiveSession.getKeystoreMaskedPassword());
        vaultOption.get("KEYSTORE_ALIAS").set(VAULT_ALIAS);
        vaultOption.get("SALT").set(salt);
        vaultOption.get("ITERATION_COUNT").set(Integer.toString(iterationCount));
        vaultOption.get("ENC_FILE_DIR").set(encryptionDirectory);
        Utils.applyUpdate(op, managementClient.getControllerClient());
        LOGGER.debug((Object)"Vault created in server configuration");
    }

    public void tearDown(ManagementClient managementClient, String containerId) throws Exception {
        ModelNode op = Util.createRemoveOperation((PathAddress)VAULT_PATH);
        Utils.applyUpdate(op, managementClient.getControllerClient());
        if (this.originalVault.get("KEYSTORE_URL") != null && this.originalVault.hasDefined("KEYSTORE_URL")) {
            Set originalVaultParam = this.originalVault.keys();
            Iterator it = originalVaultParam.iterator();
            op = Util.createAddOperation((PathAddress)VAULT_PATH);
            ModelNode vaultOption = op.get("vault-options");
            while (it.hasNext()) {
                String param = (String)it.next();
                vaultOption.get(param).set(this.originalVault.get(param));
            }
            Utils.applyUpdate(op, managementClient.getControllerClient());
        }
        this.vaultHandler.cleanUp();
    }

    private void clean() {
        File datFile3;
        File datFile2;
        File datFile1 = new File(ENC_DAT_FILE);
        if (datFile1.exists()) {
            datFile1.delete();
        }
        if ((datFile2 = new File(SHARED_DAT_FILE)).exists()) {
            datFile2.delete();
        }
        if ((datFile3 = new File(VAULT_DAT_FILE)).exists()) {
            datFile3.delete();
        }
    }
}

