/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config;

public class DataSource {
    private final String name;
    private final String connectionUrl;
    private final String driver;
    private final String username;
    private final String password;

    private DataSource(Builder builder) {
        this.name = builder.name;
        this.connectionUrl = builder.connectionUrl;
        this.driver = builder.driver;
        this.username = builder.username;
        this.password = builder.password;
    }

    public String getName() {
        return this.name;
    }

    public String getJndiName() {
        return "java:jboss/datasources/" + this.name;
    }

    public String getConnectionUrl() {
        return this.connectionUrl;
    }

    public String getDriver() {
        return this.driver;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public static class Builder {
        private String name;
        private String connectionUrl;
        private String driver;
        private String username;
        private String password;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder connectionUrl(String connectionUrl) {
            this.connectionUrl = connectionUrl;
            return this;
        }

        public Builder driver(String driver) {
            this.driver = driver;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public DataSource build() {
            return new DataSource(this);
        }
    }
}

