/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config.realm;

import org.jboss.as.test.integration.security.common.config.realm.LdapAuthentication;
import org.jboss.as.test.integration.security.common.config.realm.RealmKeystore;

public class Authentication {
    private final RealmKeystore truststore;
    private final LdapAuthentication ldap;

    private Authentication(Builder builder) {
        this.truststore = builder.truststore;
        this.ldap = builder.ldap;
    }

    public RealmKeystore getTruststore() {
        return this.truststore;
    }

    public LdapAuthentication getLdap() {
        return this.ldap;
    }

    public String toString() {
        return "Authentication [truststore=" + this.truststore + "]";
    }

    public static class Builder {
        private RealmKeystore truststore;
        private LdapAuthentication ldap;

        public Builder truststore(RealmKeystore truststore) {
            this.truststore = truststore;
            return this;
        }

        public Builder ldap(LdapAuthentication ldap) {
            this.ldap = ldap;
            return this;
        }

        public Authentication build() {
            return new Authentication(this);
        }
    }
}

