/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config.realm;

import java.nio.charset.StandardCharsets;
import org.jboss.as.test.integration.security.common.config.realm.RealmKeystore;
import org.jboss.util.Base64;

public class ServerIdentity {
    private final String secret;
    private final RealmKeystore ssl;

    private ServerIdentity(Builder builder) {
        this.secret = builder.secret;
        this.ssl = builder.ssl;
    }

    public String getSecret() {
        return this.secret;
    }

    public RealmKeystore getSsl() {
        return this.ssl;
    }

    public String toString() {
        return "ServerIdentity [secret=" + this.secret + ", ssl=" + this.ssl + "]";
    }

    public static class Builder {
        private String secret;
        private RealmKeystore ssl;

        public Builder secretBase64(String base64secret) {
            this.secret = base64secret;
            return this;
        }

        public Builder ssl(RealmKeystore ssl) {
            this.ssl = ssl;
            return this;
        }

        public Builder secretPlain(String plainSecret) {
            if (plainSecret == null) {
                this.secret = null;
                return this;
            }
            byte[] secretBytes = plainSecret.getBytes(StandardCharsets.UTF_8);
            this.secret = Base64.encodeBytes((byte[])secretBytes, (int)8);
            return this;
        }

        public ServerIdentity build() {
            return new ServerIdentity(this);
        }
    }
}

