/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class FileUtils {
    private FileUtils() {
    }

    public static String readFile(Class<?> testClass, String fileName) {
        URL res = testClass.getResource(fileName);
        return FileUtils.readFile(res);
    }

    public static String readFile(URL url) {
        BufferedInputStream stream = null;
        try {
            stream = new BufferedInputStream(url.openStream());
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public static File getFileOrCheckParentsIfNotFound(String baseStr, String path) throws FileNotFoundException {
        File base = new File(baseStr);
        if (!base.exists()) {
            throw new FileNotFoundException("Base path not found: " + base.getPath());
        }
        File f = new File(base = base.getAbsoluteFile(), path);
        if (f.exists()) {
            return f;
        }
        File fLast = f;
        while (!f.exists()) {
            int slash = path.lastIndexOf(File.separatorChar);
            if (slash <= 0) {
                throw new FileNotFoundException("Path not found: " + f.getPath());
            }
            path = path.substring(0, slash);
            fLast = f;
            f = new File(base, path);
        }
        throw new FileNotFoundException("Path not found: " + fLast.getPath());
    }

    public static void copyFile(File src, File dest) throws IOException {
        Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        Files.copy(in, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static boolean waitForFiles(File ... files) {
        long exitTime = 20000L + System.currentTimeMillis();
        do {
            boolean allExist = true;
            for (File file : files) {
                if (file.exists()) continue;
                allExist = false;
                break;
            }
            if (!allExist) continue;
            return true;
        } while (System.currentTimeMillis() < exitTime);
        return false;
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

