/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.domain.management.util;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.test.integration.domain.management.util.DomainControllerClientConfig;
import org.jboss.as.test.integration.domain.management.util.DomainLifecycleUtil;
import org.jboss.as.test.integration.domain.management.util.JBossAsManagedConfiguration;
import org.jboss.as.test.shared.FileUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.junit.Assert;

public class DomainTestSupport {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.test.integration.domain");
    public static final String masterAddress = System.getProperty("jboss.test.host.master.address", "127.0.0.1");
    public static final String slaveAddress = System.getProperty("jboss.test.host.slave.address", "127.0.0.1");
    public static final long domainBootTimeout = Long.valueOf(System.getProperty("jboss.test.domain.boot.timeout", "60000"));
    public static final long domainShutdownTimeout = Long.valueOf(System.getProperty("jboss.test.domain.shutdown.timeout", "20000"));
    public static final String masterJvmHome = System.getProperty("jboss.test.host.master.jvmhome");
    public static final String slaveJvmHome = System.getProperty("jboss.test.host.slave.jvmhome");
    public static final String masterControllerJvmHome = System.getProperty("jboss.test.host.master.controller.jvmhome");
    public static final String slaveControllerJvmHome = System.getProperty("jboss.test.host.slave.controller.jvmhome");
    private final JBossAsManagedConfiguration masterConfiguration;
    private final JBossAsManagedConfiguration slaveConfiguration;
    private final DomainLifecycleUtil domainMasterLifecycleUtil;
    private final DomainLifecycleUtil domainSlaveLifecycleUtil;
    private final DomainControllerClientConfig sharedClientConfig;
    private final String testClass;

    public static DomainTestSupport createAndStartDefaultSupport(String testName) {
        try {
            Configuration configuration = Configuration.create(testName, "domain-configs/domain-standard.xml", "host-configs/host-master.xml", "host-configs/host-slave.xml");
            DomainTestSupport testSupport = DomainTestSupport.create(configuration);
            testSupport.start();
            return testSupport;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static DomainTestSupport createAndStartSupport(Configuration configuration) {
        try {
            DomainTestSupport testSupport = DomainTestSupport.create(configuration);
            testSupport.start();
            return testSupport;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static JBossAsManagedConfiguration getMasterConfiguration(String domainConfigPath, String hostConfigPath, String testName, boolean readOnlyDomain, boolean readOnlyHost) {
        return DomainTestSupport.getMasterConfiguration(domainConfigPath, hostConfigPath, testName, null, readOnlyDomain, readOnlyHost);
    }

    public static JBossAsManagedConfiguration getMasterConfiguration(String domainConfigPath, String hostConfigPath, String testName, JBossAsManagedConfiguration baseConfig, boolean readOnlyDomain, boolean readOnlyHost) {
        return Configuration.getMasterConfiguration(domainConfigPath, hostConfigPath, testName, baseConfig, readOnlyDomain, readOnlyHost);
    }

    public static JBossAsManagedConfiguration getSlaveConfiguration(String hostConfigPath, String testName, boolean readOnlyHost) {
        return DomainTestSupport.getSlaveConfiguration(hostConfigPath, testName, new JBossAsManagedConfiguration(), readOnlyHost);
    }

    public static JBossAsManagedConfiguration getSlaveConfiguration(String hostConfigPath, String testName, JBossAsManagedConfiguration baseConfig, boolean readOnlyHost) {
        return Configuration.getSlaveConfiguration(hostConfigPath, testName, baseConfig, readOnlyHost);
    }

    private static URI toURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public static void startHosts(long timeout, DomainLifecycleUtil ... hosts) throws Exception {
        Future[] futures = new Future[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            futures[i] = hosts[i].startAsync();
        }
        DomainTestSupport.processFutures(futures, timeout);
    }

    public static void stopHosts(long timeout, DomainLifecycleUtil ... hosts) throws Exception {
        Future[] futures = new Future[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            futures[i] = hosts[i].stopAsync();
        }
        DomainTestSupport.processFutures(futures, timeout);
    }

    public static File getBaseDir(String testName) {
        return new File("target" + File.separator + "domains" + File.separator + testName);
    }

    public static File getHostDir(String testName, String hostName) {
        return new File(DomainTestSupport.getBaseDir(testName), hostName);
    }

    public static File getAddedModulesDir(String testName) {
        File f = new File(DomainTestSupport.getBaseDir(testName), "added-modules");
        f.mkdirs();
        return f;
    }

    public static File getHostOverrideModulesDir(String testName, String hostName) {
        File f = new File(DomainTestSupport.getHostDir(testName, hostName), "added-modules");
        f.mkdirs();
        return f;
    }

    public static ModelNode createOperationNode(String address, String operation) {
        ModelNode op = new ModelNode();
        ModelNode list = op.get("address").setEmptyList();
        if (address != null) {
            String[] pathSegments;
            for (String segment : pathSegments = address.split("/")) {
                String[] elements = segment.split("=");
                list.add(elements[0], elements[1]);
            }
        }
        op.get("operation").set(operation);
        return op;
    }

    public static ModelNode validateResponse(ModelNode response) {
        return DomainTestSupport.validateResponse(response, true);
    }

    public static ModelNode validateResponse(ModelNode response, boolean getResult) {
        if (!"success".equals(response.get("outcome").asString())) {
            System.out.println("Failed response:");
            System.out.println(response);
            Assert.fail((String)response.get("failure-description").toString());
        }
        if (getResult) {
            Assert.assertTrue((String)"result exists", (boolean)response.has("result"));
            return response.get("result");
        }
        return null;
    }

    public static ModelNode validateFailedResponse(ModelNode response) {
        if (!"failed".equals(response.get("outcome").asString())) {
            System.out.println("Response succeeded:");
            System.out.println(response);
            Assert.fail((String)response.get("outcome").toString());
        }
        Assert.assertTrue((String)"failure description exists", (boolean)response.has("failure-description"));
        return response.get("failure-description");
    }

    public static void cleanFile(File file) {
        if (file != null && file.exists()) {
            if (file.isDirectory()) {
                for (File child : file.listFiles()) {
                    DomainTestSupport.cleanFile(child);
                }
            }
            if (!file.delete()) {
                file.deleteOnExit();
            }
        }
    }

    public static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Throwable t) {
                log.errorf(t, "Failed to close resource %s", (Object)closeable);
            }
        }
    }

    private static void processFutures(Future<?>[] futures, long timeout) throws Exception {
        try {
            for (int i = 0; i < futures.length; ++i) {
                try {
                    futures[i].get(timeout, TimeUnit.MILLISECONDS);
                    continue;
                }
                catch (ExecutionException e) {
                    throw e.getCause();
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static void configureModulePath(JBossAsManagedConfiguration config, File ... extraModules) {
        String basePath = config.getModulePath();
        if (basePath == null || basePath.isEmpty()) {
            basePath = config.getJbossHome() + File.separatorChar + "modules";
        }
        StringBuilder path = new StringBuilder();
        for (File extraModule : extraModules) {
            path.append(extraModule.getAbsolutePath()).append(File.pathSeparatorChar);
        }
        path.append(basePath);
        config.setModulePath(path.toString());
    }

    protected DomainTestSupport(String testClass, String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfiguration masterBase, JBossAsManagedConfiguration slaveBase) throws Exception {
        this(testClass, domainConfig, masterConfig, slaveConfig, masterBase, slaveBase, false, false, false);
    }

    protected DomainTestSupport(String testClass, String domainConfig, String masterConfig, String slaveConfig, JBossAsManagedConfiguration masterBase, JBossAsManagedConfiguration slaveBase, boolean readOnlyDomainConfig, boolean readOnlyMasterHostConfig, boolean readOnlySlaveHostConfig) throws Exception {
        this(testClass, DomainTestSupport.getMasterConfiguration(domainConfig, masterConfig, testClass, masterBase, readOnlyDomainConfig, readOnlyMasterHostConfig), slaveConfig == null ? null : DomainTestSupport.getSlaveConfiguration(slaveConfig, testClass, slaveBase, readOnlySlaveHostConfig));
    }

    protected DomainTestSupport(String testClass, JBossAsManagedConfiguration masterConfiguration, JBossAsManagedConfiguration slaveConfiguration) throws Exception {
        this.testClass = testClass;
        this.sharedClientConfig = DomainControllerClientConfig.create();
        this.masterConfiguration = masterConfiguration;
        this.domainMasterLifecycleUtil = new DomainLifecycleUtil(masterConfiguration, this.sharedClientConfig);
        this.slaveConfiguration = slaveConfiguration;
        this.domainSlaveLifecycleUtil = slaveConfiguration != null ? new DomainLifecycleUtil(slaveConfiguration, this.sharedClientConfig) : null;
    }

    public static DomainTestSupport create(Configuration configuration) throws Exception {
        return new DomainTestSupport(configuration.getTestName(), configuration.getMasterConfiguration(), configuration.getSlaveConfiguration());
    }

    public static DomainTestSupport create(String testClass, Configuration configuration) throws Exception {
        return new DomainTestSupport(testClass, configuration.getMasterConfiguration(), configuration.getSlaveConfiguration());
    }

    public static DomainTestSupport create(String testClass, JBossAsManagedConfiguration masterConfiguration, JBossAsManagedConfiguration slaveConfiguration) throws Exception {
        return new DomainTestSupport(testClass, masterConfiguration, slaveConfiguration);
    }

    public JBossAsManagedConfiguration getDomainMasterConfiguration() {
        return this.masterConfiguration;
    }

    public DomainLifecycleUtil getDomainMasterLifecycleUtil() {
        return this.domainMasterLifecycleUtil;
    }

    public JBossAsManagedConfiguration getDomainSlaveConfiguration() {
        return this.slaveConfiguration;
    }

    public DomainLifecycleUtil getDomainSlaveLifecycleUtil() {
        return this.domainSlaveLifecycleUtil;
    }

    public void start() {
        this.domainMasterLifecycleUtil.start();
        if (this.domainSlaveLifecycleUtil != null) {
            this.domainSlaveLifecycleUtil.start();
        }
    }

    public void addTestModule(String moduleName, InputStream moduleXml, Map<String, StreamExporter> contents) throws IOException {
        File modulesDir = DomainTestSupport.getAddedModulesDir(this.testClass);
        DomainTestSupport.addModule(modulesDir, moduleName, moduleXml, contents);
    }

    public void addOverrideModule(String hostName, String moduleName, InputStream moduleXml, Map<String, StreamExporter> contents) throws IOException {
        File modulesDir = DomainTestSupport.getHostOverrideModulesDir(this.testClass, hostName);
        DomainTestSupport.addModule(modulesDir, moduleName, moduleXml, contents);
    }

    static void addModule(File modulesDir, String moduleName, InputStream moduleXml, Map<String, StreamExporter> resources) throws IOException {
        String modulePath = moduleName.replace('.', File.separatorChar) + File.separatorChar + "main";
        File moduleDir = new File(modulesDir, modulePath);
        moduleDir.mkdirs();
        FileUtils.copyFile(moduleXml, new File(moduleDir, "module.xml"));
        for (Map.Entry<String, StreamExporter> entry : resources.entrySet()) {
            entry.getValue().exportTo(new File(moduleDir, entry.getKey()), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            try {
                if (this.domainSlaveLifecycleUtil != null) {
                    this.domainSlaveLifecycleUtil.stop();
                }
            }
            finally {
                this.domainMasterLifecycleUtil.stop();
            }
        }
        finally {
            StreamUtils.safeClose((Closeable)this.sharedClientConfig);
        }
    }

    public static class Configuration {
        private final String testName;
        private final JBossAsManagedConfiguration masterConfiguration;
        private final JBossAsManagedConfiguration slaveConfiguration;

        protected Configuration(String testName, JBossAsManagedConfiguration masterConfiguration, JBossAsManagedConfiguration slaveConfiguration) {
            this.testName = testName;
            this.masterConfiguration = masterConfiguration;
            this.slaveConfiguration = slaveConfiguration;
        }

        public String getTestName() {
            return this.testName;
        }

        public JBossAsManagedConfiguration getMasterConfiguration() {
            return this.masterConfiguration;
        }

        public JBossAsManagedConfiguration getSlaveConfiguration() {
            return this.slaveConfiguration;
        }

        public static Configuration create(String testName, String domainConfig, String masterConfig, String slaveConfig) {
            return Configuration.create(testName, domainConfig, masterConfig, slaveConfig, false, false, false);
        }

        public static Configuration create(String testName, String domainConfig, String masterConfig, String slaveConfig, boolean readOnlyMasterDomain, boolean readOnlyMasterHost, boolean readOnlySlaveHost) {
            JBossAsManagedConfiguration masterConfiguration = Configuration.getMasterConfiguration(domainConfig, masterConfig, testName, null, readOnlyMasterDomain, readOnlyMasterHost);
            JBossAsManagedConfiguration slaveConfiguration = slaveConfig == null ? null : Configuration.getSlaveConfiguration(slaveConfig, testName, null, readOnlySlaveHost);
            return new Configuration(testName, masterConfiguration, slaveConfiguration);
        }

        private static JBossAsManagedConfiguration getMasterConfiguration(String domainConfigPath, String hostConfigPath, String testName, JBossAsManagedConfiguration baseConfig, boolean readOnlyDomain, boolean readOnlyHost) {
            String hostName = "master";
            File domains = DomainTestSupport.getBaseDir(testName);
            File extraModules = DomainTestSupport.getAddedModulesDir(testName);
            File overrideModules = DomainTestSupport.getHostOverrideModulesDir(testName, "master");
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            JBossAsManagedConfiguration masterConfig = baseConfig == null ? new JBossAsManagedConfiguration() : baseConfig;
            DomainTestSupport.configureModulePath(masterConfig, new File[]{overrideModules, extraModules});
            masterConfig.setHostControllerManagementAddress(masterAddress);
            masterConfig.setHostCommandLineProperties("-Djboss.test.host.master.address=" + masterAddress);
            masterConfig.setReadOnlyDomain(readOnlyDomain);
            masterConfig.setReadOnlyHost(readOnlyHost);
            URL url = tccl.getResource(domainConfigPath);
            assert (url != null) : "cannot find domainConfigPath";
            masterConfig.setDomainConfigFile(new File(DomainTestSupport.toURI(url)).getAbsolutePath());
            url = tccl.getResource(hostConfigPath);
            assert (url != null) : "cannot find hostConfigPath";
            masterConfig.setHostConfigFile(new File(DomainTestSupport.toURI(url)).getAbsolutePath());
            File masterDir = new File(domains, "master");
            new File(masterDir, "configuration").mkdirs();
            masterConfig.setDomainDirectory(masterDir.getAbsolutePath());
            if (masterJvmHome != null) {
                masterConfig.setJavaHome(masterJvmHome);
            }
            if (masterControllerJvmHome != null) {
                masterConfig.setControllerJavaHome(masterControllerJvmHome);
            }
            return masterConfig;
        }

        private static JBossAsManagedConfiguration getSlaveConfiguration(String hostConfigPath, String testName, JBossAsManagedConfiguration baseConfig, boolean readOnlyHost) {
            String hostName = "slave";
            File domains = DomainTestSupport.getBaseDir(testName);
            File extraModules = DomainTestSupport.getAddedModulesDir(testName);
            File overrideModules = DomainTestSupport.getHostOverrideModulesDir(testName, "slave");
            ClassLoader tccl = Thread.currentThread().getContextClassLoader();
            JBossAsManagedConfiguration slaveConfig = baseConfig == null ? new JBossAsManagedConfiguration() : baseConfig;
            DomainTestSupport.configureModulePath(slaveConfig, new File[]{overrideModules, extraModules});
            slaveConfig.setHostName("slave");
            slaveConfig.setHostControllerManagementAddress(slaveAddress);
            slaveConfig.setHostControllerManagementPort(19999);
            slaveConfig.setHostCommandLineProperties("-Djboss.test.host.master.address=" + masterAddress + " -Djboss.test.host.slave.address=" + slaveAddress);
            slaveConfig.setReadOnlyHost(readOnlyHost);
            URL url = tccl.getResource(hostConfigPath);
            slaveConfig.setHostConfigFile(new File(DomainTestSupport.toURI(url)).getAbsolutePath());
            File slaveDir = new File(domains, "slave");
            new File(slaveDir, "configuration").mkdirs();
            slaveConfig.setDomainDirectory(slaveDir.getAbsolutePath());
            if (slaveJvmHome != null) {
                slaveConfig.setJavaHome(slaveJvmHome);
            }
            if (slaveControllerJvmHome != null) {
                slaveConfig.setControllerJavaHome(slaveControllerJvmHome);
            }
            return slaveConfig;
        }
    }
}

