/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.Listener;
import org.jboss.as.test.integration.management.base.AbstractMgmtTestBase;
import org.jboss.as.test.integration.management.util.ModelUtil;
import org.jboss.as.test.integration.management.util.WebUtil;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;

public class ServerManager
extends AbstractMgmtTestBase {
    private final ManagementClient managementClient;

    public ServerManager(ManagementClient managementClient) {
        this.managementClient = managementClient;
    }

    @Override
    protected ModelControllerClient getModelControllerClient() {
        return this.managementClient.getControllerClient();
    }

    public void addListener(Listener conn, int port, String keyPEMFile, String certPEMFile, String keyStoreFile, String password) throws Exception {
        ModelNode op = this.getAddSocketBindingOp(conn, port);
        this.executeOperation(op);
        op = this.getAddListenerOp(conn, keyStoreFile, password);
        this.executeOperation(op);
        Assert.assertTrue((boolean)this.getListenerList().get(conn.getScheme()).contains("test-" + conn.getName() + "-listener"));
    }

    private ModelNode getAddSocketBindingOp(Listener conn, int port) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "add");
        op.get("port").set(port);
        return op;
    }

    private ModelNode getAddListenerOp(Listener conn, String keyStoreFile, String password) {
        ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = composite.get("steps");
        ModelNode op = ModelUtil.createOpNode("subsystem=undertow/server=default-server/" + conn.getScheme() + "-listener=test-" + conn.getName() + "-listener", "add");
        op.get("socket-binding").set("test-" + conn.getName());
        if (conn.isSecure()) {
            this.addSecurityRealm(steps, keyStoreFile, password);
            op.get("security-realm").set("ssl-realm");
        }
        steps.add(op);
        return composite;
    }

    private void addSecurityRealm(ModelNode steps, String keyStoreFile, String password) {
        PathAddress realmAddr = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("core-service", "management").append("security-realm", "ssl-realm");
        ModelNode op = Util.createAddOperation((PathAddress)realmAddr);
        steps.add(op);
        ModelNode sslModuleNode = Util.createAddOperation((PathAddress)realmAddr.append("server-identity", "ssl"));
        sslModuleNode.get("keystore-path").set(keyStoreFile);
        sslModuleNode.get("keystore-password").set(password);
        sslModuleNode.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
        steps.add(sslModuleNode);
    }

    private ModelNode getRemoveSecurityRealm() {
        PathAddress realmAddr = PathAddress.pathAddress((PathElement[])new PathElement[0]).append("core-service", "management").append("security-realm", "ssl-realm");
        return Util.createRemoveOperation((PathAddress)realmAddr);
    }

    public void removeListener(Listener conn, String checkURL) throws Exception {
        ModelNode op = this.getRemoveListenerOp(conn);
        this.executeOperation(op);
        Thread.sleep(1000L);
        if (checkURL != null) {
            Assert.assertFalse((String)"Listener not removed.", (boolean)WebUtil.testHttpURL(checkURL));
        }
        op = this.getRemoveSocketBindingOp(conn);
        this.executeOperation(op);
    }

    private ModelNode getRemoveSocketBindingOp(Listener conn) {
        ModelNode op = ModelUtil.createOpNode("socket-binding-group=standard-sockets/socket-binding=test-" + conn.getName(), "remove");
        op.get("operation-headers").get("allow-resource-service-restart").set(true);
        return op;
    }

    private ModelNode getRemoveListenerOp(Listener conn) {
        ModelNode composite = Util.getEmptyOperation((String)"composite", (ModelNode)new ModelNode());
        ModelNode steps = composite.get("steps");
        ModelNode op = ModelUtil.createOpNode("subsystem=undertow/server=default-server/" + conn.getScheme() + "-listener=test-" + conn.getName() + "-listener", "remove");
        op.get(new String[]{"operation-headers", "allow-resource-service-restart"}).set(true);
        steps.add(op);
        if (conn.isSecure()) {
            steps.add(this.getRemoveSecurityRealm());
        }
        return composite;
    }

    private Map<String, Set<String>> getListenerList() throws Exception {
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        result.put("http", this.getListenersByType("http-listener"));
        result.put("https", this.getListenersByType("https-listener"));
        result.put("ajp", this.getListenersByType("ajp-listener"));
        return result;
    }

    private Set<String> getListenersByType(String type) throws Exception {
        ModelNode op = ModelUtil.createOpNode("subsystem=undertow/server=default-server", "read-children-names");
        op.get("child-type").set(type);
        ModelNode result = this.executeOperation(op);
        List connectors = result.asList();
        HashSet<String> connNames = new HashSet<String>();
        for (ModelNode n : connectors) {
            connNames.add(n.asString());
        }
        return connNames;
    }
}

