/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.rbac;

import java.io.IOException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.test.integration.management.rbac.Outcome;
import org.jboss.as.test.integration.management.rbac.RbacUtil;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.junit.Assert;

public class PermissionsCoverageTestUtil {
    public static void assertTheEntireDomainTreeHasPermissionsDefined(ModelControllerClient client) throws IOException {
        ModelNode operation = Util.createOperation((String)"read-resource", (PathAddress)PathAddress.EMPTY_ADDRESS);
        operation.get("recursive").set(true);
        ModelNode resource = RbacUtil.executeOperation(client, operation, Outcome.SUCCESS).get("result");
        operation = Util.createOperation((String)"read-resource-description", (PathAddress)PathAddress.EMPTY_ADDRESS);
        operation.get("recursive").set(true);
        operation.get("access-control").set("combined-descriptions");
        ModelNode resourceDescription = RbacUtil.executeOperation(client, operation, Outcome.SUCCESS).get("result");
        PermissionsCoverageTestUtil.verify(resource, resourceDescription, DescriptionContainer.CHILDREN, "");
    }

    private static void verify(ModelNode resource, ModelNode resourceDescription, DescriptionContainer descriptionContainer, String currentPath) {
        if (!resource.isDefined()) {
            return;
        }
        assert (resource.getType() == ModelType.OBJECT);
        System.out.println("Verifying " + (currentPath.isEmpty() ? "<root>" : currentPath));
        if (descriptionContainer.shouldHaveAccessControlSibling) {
            Assert.assertTrue((boolean)resourceDescription.has("access-control"));
            ModelNode accessControl = resourceDescription.get("access-control");
            Assert.assertTrue((boolean)accessControl.has("default"));
            ModelNode defaultAccessControl = accessControl.get("default");
            Assert.assertTrue((boolean)defaultAccessControl.has("read"));
            Assert.assertEquals((Object)ModelType.BOOLEAN, (Object)defaultAccessControl.get("read").getType());
            Assert.assertTrue((boolean)defaultAccessControl.has("write"));
            Assert.assertEquals((Object)ModelType.BOOLEAN, (Object)defaultAccessControl.get("write").getType());
        }
        for (String key : resource.keys()) {
            ModelNode childDescription;
            ModelNode child;
            if (resourceDescription.get("attributes").has(key)) continue;
            if (resourceDescription.get(descriptionContainer.name).has(key)) {
                child = resource.get(key);
                childDescription = resourceDescription.get(new String[]{descriptionContainer.name, key});
                PermissionsCoverageTestUtil.verify(child, childDescription, descriptionContainer.next(), currentPath + descriptionContainer.pathSeparator + key);
                continue;
            }
            if (resourceDescription.get(descriptionContainer.name).has("*")) {
                child = resource.get(key);
                childDescription = resourceDescription.get(new String[]{descriptionContainer.name, "*"});
                PermissionsCoverageTestUtil.verify(child, childDescription, descriptionContainer.next(), currentPath + descriptionContainer.pathSeparator + key);
                continue;
            }
            Assert.fail((String)("No description for key " + key));
        }
    }

    private static enum DescriptionContainer {
        CHILDREN("children", true, "/"),
        MODEL_DESCRIPTION("model-description", false, "=");

        public final String name;
        public final boolean shouldHaveAccessControlSibling;
        public final String pathSeparator;

        private DescriptionContainer(String name, boolean shouldHaveAccessControlSibling, String pathSeparator) {
            this.name = name;
            this.shouldHaveAccessControlSibling = shouldHaveAccessControlSibling;
            this.pathSeparator = pathSeparator;
        }

        public DescriptionContainer next() {
            return this == CHILDREN ? MODEL_DESCRIPTION : CHILDREN;
        }

        public String toString() {
            return this.name.toUpperCase();
        }
    }
}

