/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.management.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.as.test.shared.TimeoutUtil;
import org.jboss.logging.Logger;
import org.junit.Assert;

public class CustomCLIExecutor {
    public static final int MANAGEMENT_NATIVE_PORT = 9999;
    public static final int MANAGEMENT_HTTP_PORT = 9990;
    public static final int MANAGEMENT_HTTPS_PORT = 9993;
    public static final String NATIVE_CONTROLLER = "remoting://" + TestSuiteEnvironment.getServerAddress() + ":" + 9999;
    public static final String HTTP_CONTROLLER = "http-remoting://" + TestSuiteEnvironment.getServerAddress() + ":" + 9990;
    public static final String HTTPS_CONTROLLER = "https-remoting://" + TestSuiteEnvironment.getServerAddress() + ":" + 9993;
    private static Logger LOGGER = Logger.getLogger(CustomCLIExecutor.class);
    private static final int CLI_PROC_TIMEOUT = 5000;
    private static final int STATUS_CHECK_INTERVAL = 2000;

    public static String execute(File cliConfigFile, String operation) {
        String defaultController = TestSuiteEnvironment.getServerAddress() + ":" + TestSuiteEnvironment.getServerPort();
        return CustomCLIExecutor.execute(cliConfigFile, operation, defaultController, false);
    }

    public static String execute(File cliConfigFile, String operation, String controller) {
        return CustomCLIExecutor.execute(cliConfigFile, operation, controller, false);
    }

    public static String execute(File cliConfigFile, String operation, String controller, boolean logFailure) {
        String modulePath;
        String jbossDist = System.getProperty("jboss.dist");
        if (jbossDist == null) {
            Assert.fail((String)"jboss.dist system property is not set");
        }
        if ((modulePath = System.getProperty("module.path")) == null) {
            Assert.fail((String)"module.path system property is not set");
        }
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.redirectErrorStream(true);
        ArrayList<String> command = new ArrayList<String>();
        command.add(TestSuiteEnvironment.getJavaPath());
        TestSuiteEnvironment.getIpv6Args(command);
        if (cliConfigFile != null) {
            command.add("-Djboss.cli.config=" + cliConfigFile.getAbsolutePath());
        } else {
            command.add("-Djboss.cli.config=" + jbossDist + File.separator + "bin" + File.separator + "jboss-cli.xml");
        }
        command.add("-jar");
        command.add(jbossDist + File.separatorChar + "jboss-modules.jar");
        command.add("-mp");
        command.add(modulePath);
        command.add("org.jboss.as.cli");
        command.add("-c");
        command.add("--controller=" + controller);
        command.add(operation);
        builder.command(command);
        Process cliProc = null;
        try {
            cliProc = builder.start();
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to start CLI process: " + e.getLocalizedMessage()));
        }
        InputStream cliStream = cliProc.getInputStream();
        StringBuilder cliOutBuf = new StringBuilder();
        boolean wait = true;
        int runningTime = 0;
        int exitCode = 0;
        do {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            runningTime += 2000;
            CustomCLIExecutor.readStream(cliOutBuf, cliStream);
            try {
                exitCode = cliProc.exitValue();
                wait = false;
                CustomCLIExecutor.readStream(cliOutBuf, cliStream);
            }
            catch (IllegalThreadStateException e) {
                // empty catch block
            }
            if (runningTime < 5000) continue;
            CustomCLIExecutor.readStream(cliOutBuf, cliStream);
            cliProc.destroy();
            wait = false;
        } while (wait);
        String cliOutput = cliOutBuf.toString();
        if (logFailure && exitCode != 0) {
            LOGGER.info((Object)("Command's output: '" + cliOutput + "'"));
            try {
                int bytesTotal = cliProc.getErrorStream().available();
                if (bytesTotal > 0) {
                    byte[] bytes = new byte[bytesTotal];
                    cliProc.getErrorStream().read(bytes);
                    LOGGER.info((Object)("Command's error log: '" + new String(bytes) + "'"));
                } else {
                    LOGGER.info((Object)"No output data for the command.");
                }
            }
            catch (IOException e) {
                Assert.fail((String)("Failed to read command's error output: " + e.getLocalizedMessage()));
            }
        }
        return exitCode + ": " + cliOutput;
    }

    private static void readStream(StringBuilder cliOutBuf, InputStream cliStream) {
        try {
            int bytesTotal = cliStream.available();
            if (bytesTotal > 0) {
                byte[] bytes = new byte[bytesTotal];
                cliStream.read(bytes);
                cliOutBuf.append(new String(bytes));
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Failed to read command's output: " + e.getLocalizedMessage()));
        }
    }

    public static void waitForServerToReload(int timeout, String controller) throws Exception {
        long now;
        Thread.sleep(TimeoutUtil.adjust(500));
        long start = System.currentTimeMillis();
        do {
            try {
                String result = CustomCLIExecutor.execute(null, "read-attribute server-state", controller);
                boolean normal = result.contains("running");
                if (normal) {
                    return;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        } while ((now = System.currentTimeMillis()) - start < (long)timeout);
        Assert.fail((String)"Server did not reload in the imparted time.");
    }
}

