/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.io.IOUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.jboss.logging.Logger;

public class SSLTruststoreUtil {
    private static final Logger LOGGER = Logger.getLogger(SSLTruststoreUtil.class);
    public static final int HTTPS_PORT = 8443;
    public static final int HTTPS_PORT_VERIFY_FALSE = 18443;
    public static final int HTTPS_PORT_VERIFY_WANT = 18444;
    public static final int HTTPS_PORT_VERIFY_TRUE = 18445;
    public static final int[] HTTPS_PORTS = new int[]{18443, 18445, 18444};
    private static final String HTTPS = "https";

    public static DefaultHttpClient getHttpClientWithSSL(File trustStoreFile, String password) {
        return SSLTruststoreUtil.getHttpClientWithSSL(null, null, trustStoreFile, password);
    }

    public static DefaultHttpClient getHttpClientWithSSL(File keyStoreFile, String keyStorePassword, File trustStoreFile, String trustStorePassword) {
        try {
            KeyStore truststore = SSLTruststoreUtil.loadKeyStore(trustStoreFile, trustStorePassword.toCharArray());
            KeyStore keystore = keyStoreFile != null ? SSLTruststoreUtil.loadKeyStore(keyStoreFile, keyStorePassword.toCharArray()) : null;
            SSLSocketFactory ssf = new SSLSocketFactory("TLS", keystore, keyStorePassword, truststore, null, SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
            BasicHttpParams params = new BasicHttpParams();
            SchemeRegistry registry = new SchemeRegistry();
            registry.register(new Scheme("http", 9990, (SchemeSocketFactory)PlainSocketFactory.getSocketFactory()));
            registry.register(new Scheme(HTTPS, 9993, (SchemeSocketFactory)ssf));
            for (int port : HTTPS_PORTS) {
                registry.register(new Scheme(HTTPS, port, (SchemeSocketFactory)ssf));
            }
            PoolingClientConnectionManager ccm = new PoolingClientConnectionManager(registry);
            return new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
        }
        catch (Exception e) {
            LOGGER.error((Object)"Creating HttpClient with customized SSL failed. We are returning the default one instead.", (Throwable)e);
            return new DefaultHttpClient();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeyStore(File keystoreFile, char[] keystorePwd) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keystore = KeyStore.getInstance("JKS");
        FileInputStream is = null;
        try {
            is = new FileInputStream(keystoreFile);
            keystore.load(is, keystorePwd);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(is);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)is);
        return keystore;
    }
}

