/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class SecurityModule {
    private final String name;
    private final String flag;
    private final Map<String, String> options;

    private SecurityModule(Builder builder) {
        this.name = builder.name;
        this.flag = builder.flag;
        this.options = builder.options == null ? null : Collections.unmodifiableMap(new HashMap(builder.options));
    }

    public final String getName() {
        return this.name;
    }

    public final String getFlag() {
        return this.flag;
    }

    public final Map<String, String> getOptions() {
        return this.options;
    }

    public static class Builder {
        private String name;
        private String flag;
        private Map<String, String> options;

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder flag(String flag) {
            this.flag = flag;
            return this;
        }

        public Builder options(Map<String, String> options) {
            this.options = options;
            return this;
        }

        public Builder putOption(String name, String value) {
            if (this.options == null) {
                this.options = new HashMap<String, String>();
            }
            this.options.put(name, value);
            return this;
        }

        public SecurityModule build() {
            return new SecurityModule(this);
        }
    }
}

