/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common.negotiation;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;

public class JBossNegotiateScheme
extends AuthSchemeBase {
    private static final Logger LOGGER = Logger.getLogger(JBossNegotiateScheme.class);
    private static final int DEFAULT_LIFETIME = 60;
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private final boolean stripPort;
    private State state = State.UNINITIATED;
    private byte[] token;
    private final Base64 base64codec;

    public JBossNegotiateScheme(boolean stripPort) {
        this.stripPort = stripPort;
        this.base64codec = new Base64(0);
    }

    public boolean isComplete() {
        return this.state == State.TOKEN_GENERATED || this.state == State.FAILED;
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        if (this.state != State.CHALLENGE_RECEIVED) {
            throw new IllegalStateException("Negotiation authentication process has not been initiated");
        }
        try {
            String key = null;
            key = this.isProxy() ? "http.proxy_host" : "http.target_host";
            HttpHost host = (HttpHost)context.getAttribute(key);
            if (host == null) {
                throw new AuthenticationException("Authentication host is not set in the execution context");
            }
            String authServer = !this.stripPort && host.getPort() > 0 ? host.toHostString() : host.getHostName();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("init " + authServer));
            }
            Oid negotiationOid = new Oid(SPNEGO_OID);
            GSSManager manager = GSSManager.getInstance();
            GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
            GSSContext gssContext = manager.createContext(serverName.canonicalize(negotiationOid), negotiationOid, null, 60);
            gssContext.requestMutualAuth(true);
            gssContext.requestCredDeleg(true);
            if (this.token == null) {
                this.token = new byte[0];
            }
            this.token = gssContext.initSecContext(this.token, 0, this.token.length);
            if (this.token == null) {
                this.state = State.FAILED;
                throw new AuthenticationException("GSS security context initialization failed");
            }
            this.state = State.TOKEN_GENERATED;
            String tokenstr = new String(this.base64codec.encode(this.token));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Sending response '" + tokenstr + "' back to the auth server"));
            }
            CharArrayBuffer buffer = new CharArrayBuffer(32);
            if (this.isProxy()) {
                buffer.append("Proxy-Authorization");
            } else {
                buffer.append("Authorization");
            }
            buffer.append(": Negotiate ");
            buffer.append(tokenstr);
            return new BufferedHeader(buffer);
        }
        catch (GSSException gsse) {
            this.state = State.FAILED;
            if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 13) {
                throw new InvalidCredentialsException(gsse.getMessage(), (Throwable)gsse);
            }
            if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                throw new AuthenticationException(gsse.getMessage(), (Throwable)gsse);
            }
            throw new AuthenticationException(gsse.getMessage());
        }
    }

    public String getParameter(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        String challenge = buffer.substringTrimmed(beginIndex, endIndex);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Received challenge '" + challenge + "' from the auth server"));
        }
        if (this.state == State.UNINITIATED) {
            this.token = new Base64().decode(challenge.getBytes());
            this.state = State.CHALLENGE_RECEIVED;
        } else {
            LOGGER.debug((Object)"Authentication already attempted");
            this.state = State.FAILED;
        }
    }

    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

