/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexWriter;
import org.jboss.jandex.Indexer;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;

public class TempTestModule {
    private static final Logger log = Logger.getLogger(TempTestModule.class);
    private final String moduleName;
    private final File moduleXml;
    private final String[] dependencies;
    private final List<ClassCallback> classCallbacks = new ArrayList<ClassCallback>();
    private final List<JavaArchive> resources = new ArrayList<JavaArchive>();

    public TempTestModule(String moduleName, File moduleXml) {
        if (!moduleXml.exists()) {
            throw new IllegalArgumentException("The module definition must exists.");
        }
        this.moduleName = moduleName;
        this.moduleXml = moduleXml;
        this.dependencies = null;
    }

    public TempTestModule(String moduleName, String ... dependencies) {
        this.moduleName = moduleName;
        this.moduleXml = null;
        this.dependencies = dependencies;
    }

    public void create() throws IOException {
        this.create(true);
    }

    public TempTestModule addClassCallback(ClassCallback callback) {
        this.classCallbacks.add(callback);
        return this;
    }

    public void create(boolean deleteFirst) throws IOException {
        File mainDirectory;
        File moduleDirectory = this.getModuleDirectory();
        if (moduleDirectory.exists()) {
            if (!deleteFirst) {
                throw new IllegalArgumentException(moduleDirectory + " already exists.");
            }
            this.remove();
        }
        if (!(mainDirectory = new File(moduleDirectory, "main")).mkdirs()) {
            throw new IllegalArgumentException("Could not create " + mainDirectory);
        }
        try {
            if (this.moduleXml != null) {
                TempTestModule.copyFile(new File(mainDirectory, "module.xml"), new FileInputStream(this.moduleXml));
            } else {
                this.generateModuleXml(mainDirectory);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Could not create module definition.", e);
        }
        for (JavaArchive resourceRoot : this.resources) {
            OutputStream jarFile = null;
            try {
                Indexer indexer = new Indexer();
                ArrayList classes = new ArrayList();
                for (Node content : resourceRoot.getContent().values()) {
                    String path = content.getPath().get();
                    if (!path.endsWith(".class")) continue;
                    indexer.index(content.getAsset().openStream());
                    if (this.classCallbacks.size() <= 0) continue;
                    String usePath = path.startsWith("/") ? path.substring(1, path.length() - 6) : path.substring(0, path.length() - 6);
                    usePath = usePath.replaceAll("/", ".");
                    Class<?> clazz = Class.forName(usePath);
                    classes.add(clazz);
                }
                for (ClassCallback callback : this.classCallbacks) {
                    callback.classesAdded(resourceRoot, classes);
                }
                Index index = indexer.complete();
                ByteArrayOutputStream data = new ByteArrayOutputStream();
                IndexWriter writer = new IndexWriter((OutputStream)data);
                writer.write(index);
                resourceRoot.addAsManifestResource((Asset)new ByteArrayAsset(data.toByteArray()), "jandex.idx");
                jarFile = new FileOutputStream(new File(mainDirectory, resourceRoot.getName()));
                ((ZipExporter)resourceRoot.as(ZipExporter.class)).exportTo(jarFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create module resource [" + resourceRoot.getName() + ".", e);
            }
            finally {
                if (jarFile == null) continue;
                jarFile.flush();
                ((FileOutputStream)jarFile).close();
            }
        }
    }

    public void remove() {
        this.remove(this.getModuleDirectory());
    }

    public JavaArchive addResource(String fileName) {
        JavaArchive resource = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)fileName);
        if (this.resources.size() == 0) {
            resource.addClass(TempTestModule.class);
        }
        this.resources.add(resource);
        return resource;
    }

    private void remove(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (String name : file.list()) {
                    this.remove(new File(file, name));
                }
            }
            if (!file.delete()) {
                log.error((Object)("Could not delete [" + file.getPath() + "."));
            }
        } else {
            throw new IllegalStateException("Module [" + this.moduleName + "] does not exists.");
        }
    }

    private File getModuleDirectory() {
        return new File(this.getModulesDirectory(), this.moduleName.replace('.', File.separatorChar));
    }

    private File getModulesDirectory() {
        String modulePath = System.getProperty("module.path", null);
        if (modulePath == null) {
            String jbossHome = System.getProperty("jboss.home", null);
            if (jbossHome == null) {
                throw new IllegalStateException("Neither -Dmodule.path nor -Djboss.home were set");
            }
            modulePath = jbossHome + File.separatorChar + "modules";
        } else {
            modulePath = modulePath.split(File.pathSeparator)[0];
        }
        File moduleDir = new File(modulePath);
        if (!moduleDir.exists()) {
            throw new IllegalStateException("Determined module path does not exist");
        }
        if (!moduleDir.isDirectory()) {
            throw new IllegalStateException("Determined module path is not a dir");
        }
        return moduleDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File target, InputStream src) throws IOException {
        try (BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(target));){
            int i = src.read();
            while (i != -1) {
                out.write(i);
                i = src.read();
            }
        }
    }

    public String getName() {
        return this.moduleName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateModuleXml(File mainDirectory) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(new File(mainDirectory, "module.xml")));){
            writer.write("<module xmlns=\"urn:jboss:module:1.1\" name=\"" + this.moduleName + "\">");
            writer.write("<resources>");
            for (JavaArchive jar : this.resources) {
                writer.write("<resource-root path=\"" + jar.getName() + "\"/>");
            }
            writer.write("</resources>");
            writer.write("<dependencies>");
            for (String dependency : this.dependencies) {
                writer.write("<module name=\"" + dependency + "\"/>");
            }
            writer.write("</dependencies>");
            writer.write("</module>");
        }
    }

    public static interface ClassCallback {
        public void classesAdded(JavaArchive var1, List<Class<?>> var2);
    }
}

