/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.integration.security.common;

import org.apache.directory.server.annotations.CreateChngPwdServer;
import org.apache.directory.server.annotations.CreateKdcServer;
import org.apache.directory.server.annotations.CreateTransport;
import org.apache.directory.server.core.annotations.AnnotationUtils;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.factory.ServerAnnotationProcessor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.kerberos.ChangePasswordConfig;
import org.apache.directory.server.kerberos.KerberosConfig;
import org.apache.directory.server.kerberos.changepwd.ChangePasswordServer;
import org.apache.directory.server.kerberos.kdc.KdcServer;
import org.apache.directory.server.protocol.shared.transport.TcpTransport;
import org.apache.directory.server.protocol.shared.transport.Transport;
import org.apache.directory.server.protocol.shared.transport.UdpTransport;
import org.apache.mina.util.AvailablePortFinder;
import org.jboss.as.test.integration.security.common.NoReplayKdcServer;

public class KDCServerAnnotationProcessor {
    public static KdcServer getKdcServer(DirectoryService directoryService, int startPort, String address) throws Exception {
        CreateKdcServer createKdcServer = (CreateKdcServer)AnnotationUtils.getInstance(CreateKdcServer.class);
        return KDCServerAnnotationProcessor.createKdcServer(createKdcServer, directoryService, startPort, address);
    }

    private static KdcServer createKdcServer(CreateKdcServer createKdcServer, DirectoryService directoryService, int startPort, String bindAddress) {
        if (createKdcServer == null) {
            return null;
        }
        KerberosConfig kdcConfig = new KerberosConfig();
        kdcConfig.setServicePrincipal(createKdcServer.kdcPrincipal());
        kdcConfig.setPrimaryRealm(createKdcServer.primaryRealm());
        kdcConfig.setMaximumTicketLifetime(createKdcServer.maxTicketLifetime());
        kdcConfig.setMaximumRenewableLifetime(createKdcServer.maxRenewableLifetime());
        kdcConfig.setPaEncTimestampRequired(false);
        NoReplayKdcServer kdcServer = new NoReplayKdcServer(kdcConfig);
        kdcServer.setSearchBaseDn(createKdcServer.searchBaseDn());
        UdpTransport transportBuilders = createKdcServer.transports();
        if (transportBuilders == null) {
            UdpTransport defaultTransport = new UdpTransport(bindAddress, AvailablePortFinder.getNextAvailable((int)startPort));
            kdcServer.addTransports(new Transport[]{defaultTransport});
        } else if (((CreateTransport[])transportBuilders).length > 0) {
            for (UdpTransport transportBuilder : transportBuilders) {
                String address;
                String protocol = transportBuilder.protocol();
                int port = transportBuilder.port();
                int nbThreads = transportBuilder.nbThreads();
                int backlog = transportBuilder.backlog();
                String string = address = bindAddress != null ? bindAddress : transportBuilder.address();
                if (port == -1) {
                    port = AvailablePortFinder.getNextAvailable((int)startPort);
                    startPort = port + 1;
                }
                if (protocol.equalsIgnoreCase("TCP")) {
                    TcpTransport tcp = new TcpTransport(address, port, nbThreads, backlog);
                    kdcServer.addTransports(new Transport[]{tcp});
                    continue;
                }
                if (protocol.equalsIgnoreCase("UDP")) {
                    UdpTransport udp = new UdpTransport(address, port);
                    kdcServer.addTransports(new Transport[]{udp});
                    continue;
                }
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_689, (Object[])new Object[]{protocol}));
            }
        }
        CreateChngPwdServer[] createChngPwdServers = createKdcServer.chngPwdServer();
        if (createChngPwdServers.length > 0) {
            CreateChngPwdServer createChngPwdServer = createChngPwdServers[0];
            ChangePasswordConfig config = new ChangePasswordConfig(kdcConfig);
            config.setServicePrincipal(createChngPwdServer.srvPrincipal());
            ChangePasswordServer chngPwdServer = new ChangePasswordServer(config);
            for (CreateTransport transportBuilder : createChngPwdServer.transports()) {
                Transport t = ServerAnnotationProcessor.createTransport((CreateTransport)transportBuilder, (int)startPort);
                startPort = t.getPort() + 1;
                chngPwdServer.addTransports(new Transport[]{t});
            }
            chngPwdServer.setDirectoryService(directoryService);
            kdcServer.setChangePwdServer(chngPwdServer);
        }
        kdcServer.setDirectoryService(directoryService);
        try {
            kdcServer.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return kdcServer;
    }
}

