/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.test.shared;

import java.io.Closeable;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.test.shared.TestSuiteEnvironment;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.xnio.IoUtils;

public class ServerReload {
    public static final int TIMEOUT = 100000;

    public static void executeReloadAndWaitForCompletion(ModelControllerClient client) {
        ServerReload.executeReload(client);
        ServerReload.waitForLiveServerToReload(100000);
    }

    private static void executeReload(ModelControllerClient client) {
        block2: {
            ModelNode operation = new ModelNode();
            operation.get("address").setEmptyList();
            operation.get("operation").set("reload");
            try {
                ModelNode result = client.execute(operation);
                Assert.assertEquals((Object)"success", (Object)result.get("outcome").asString());
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause instanceof ExecutionException || cause instanceof CancellationException) break block2;
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitForLiveServerToReload(int timeout) {
        long start = System.currentTimeMillis();
        ModelNode operation = new ModelNode();
        operation.get("address").setEmptyList();
        operation.get("operation").set("read-attribute");
        operation.get("name").set("server-state");
        while (System.currentTimeMillis() - start < (long)timeout) {
            try {
                ModelControllerClient liveClient = ModelControllerClient.Factory.create((String)TestSuiteEnvironment.getServerAddress(), (int)TestSuiteEnvironment.getServerPort());
                try {
                    ModelNode result = liveClient.execute(operation);
                    if ("running".equals(result.get("result").asString())) {
                        return;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    IoUtils.safeClose((Closeable)liveClient);
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {}
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        Assert.fail((String)"Live Server did not reload in the imparted time.");
    }
}

