/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.txn.deployment;

import java.util.List;
import javax.transaction.TransactionScoped;
import javax.transaction.Transactional;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.jandex.DotName;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;

public class TransactionDependenciesProcessor
implements DeploymentUnitProcessor {
    public static final ModuleIdentifier JTS_MODULE = ModuleIdentifier.create((String)"org.jboss.jts");
    public static final ModuleIdentifier TRANSACTION_API = ModuleIdentifier.create((String)"javax.transaction.api");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, TRANSACTION_API, false, false, true, false));
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, ModuleIdentifier.fromString((String)"org.wildfly.transaction.client"), false, false, true, false));
        CompositeIndex compositeIndex = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (compositeIndex == null) {
            return;
        }
        List transactionalAnnotations = compositeIndex.getAnnotations(DotName.createSimple((String)Transactional.class.getName()));
        List transactionScopedAnnotations = compositeIndex.getAnnotations(DotName.createSimple((String)TransactionScoped.class.getName()));
        if (!transactionalAnnotations.isEmpty() || !transactionScopedAnnotations.isEmpty()) {
            this.addJTSModuleDependencyToDeployment(unit);
        }
    }

    private void addJTSModuleDependencyToDeployment(DeploymentUnit unit) {
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        ModuleSpecification moduleSpec = (ModuleSpecification)unit.getAttachment(Attachments.MODULE_SPECIFICATION);
        moduleSpec.addSystemDependency(new ModuleDependency(moduleLoader, JTS_MODULE, false, false, true, false));
    }
}

