/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.server.session.Session;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.servlet.api.Deployment;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.as.controller.AbstractRuntimeOnlyHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceController;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.deployment.UndertowDeploymentService;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class DeploymentDefinition
extends SimpleResourceDefinition {
    private static final ResourceDescriptionResolver DEFAULT_RESOLVER = UndertowExtension.getResolver("deployment");
    public static final DeploymentDefinition INSTANCE = new DeploymentDefinition();
    public static final AttributeDefinition SERVER = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("server", ModelType.STRING).setStorageRuntime()).build();
    public static final AttributeDefinition CONTEXT_ROOT = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("context-root", ModelType.STRING).setStorageRuntime()).build();
    public static final AttributeDefinition VIRTUAL_HOST = ((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("virtual-host", ModelType.STRING).setStorageRuntime()).build();
    static final AttributeDefinition SESSIOND_ID = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-id", ModelType.STRING).setRequired(true)).setAllowExpression(false)).build();
    static final AttributeDefinition ATTRIBUTE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("attribute", ModelType.STRING).setRequired(true)).setAllowExpression(false)).build();
    static final OperationDefinition INVALIDATE_SESSION = new SimpleOperationDefinitionBuilder("invalidate-session", DEFAULT_RESOLVER).addParameter(SESSIOND_ID).setRuntimeOnly().setReplyType(ModelType.BOOLEAN).build();
    static final OperationDefinition LIST_SESSIONS = new SimpleOperationDefinitionBuilder("list-sessions", DEFAULT_RESOLVER).setRuntimeOnly().setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationDefinition LIST_SESSION_ATTRIBUTE_NAMES = new SimpleOperationDefinitionBuilder("list-session-attribute-names", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.LIST).setReplyValueType(ModelType.STRING).build();
    static final OperationDefinition LIST_SESSION_ATTRIBUTES = new SimpleOperationDefinitionBuilder("list-session-attributes", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.LIST).setReplyValueType(ModelType.PROPERTY).build();
    static final OperationDefinition GET_SESSION_ATTRIBUTE = new SimpleOperationDefinitionBuilder("get-session-attribute", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).addParameter(ATTRIBUTE).setReplyType(ModelType.STRING).setReplyValueType(ModelType.PROPERTY).build();
    static final OperationDefinition GET_SESSION_LAST_ACCESSED_TIME = new SimpleOperationDefinitionBuilder("get-session-last-accessed-time", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.STRING).build();
    static final OperationDefinition GET_SESSION_LAST_ACCESSED_TIME_MILLIS = new SimpleOperationDefinitionBuilder("get-session-last-accessed-time-millis", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.LONG).build();
    static final OperationDefinition GET_SESSION_CREATION_TIME = new SimpleOperationDefinitionBuilder("get-session-creation-time", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.STRING).build();
    static final OperationDefinition GET_SESSION_CREATION_TIME_MILLIS = new SimpleOperationDefinitionBuilder("get-session-creation-time-millis", DEFAULT_RESOLVER).setRuntimeOnly().addParameter(SESSIOND_ID).setReplyType(ModelType.LONG).build();

    private DeploymentDefinition() {
        super(new SimpleResourceDefinition.Parameters(PathElement.pathElement((String)"subsystem", (String)"undertow"), DEFAULT_RESOLVER).setFeature(false).setRuntime());
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(CONTEXT_ROOT, null);
        resourceRegistration.registerReadOnlyAttribute(VIRTUAL_HOST, null);
        resourceRegistration.registerReadOnlyAttribute(SERVER, null);
        for (SessionStat stat : SessionStat.values()) {
            resourceRegistration.registerMetric(stat.definition, (OperationStepHandler)SessionManagerStatsHandler.getInstance());
        }
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
        super.registerOperations(resourceRegistration);
        SessionManagerOperationHandler handler = new SessionManagerOperationHandler();
        resourceRegistration.registerOperationHandler(INVALIDATE_SESSION, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(LIST_SESSIONS, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(LIST_SESSION_ATTRIBUTE_NAMES, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(LIST_SESSION_ATTRIBUTES, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(GET_SESSION_ATTRIBUTE, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(GET_SESSION_LAST_ACCESSED_TIME, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(GET_SESSION_LAST_ACCESSED_TIME_MILLIS, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(GET_SESSION_CREATION_TIME, (OperationStepHandler)handler);
        resourceRegistration.registerOperationHandler(GET_SESSION_CREATION_TIME_MILLIS, (OperationStepHandler)handler);
    }

    private static SessionManager getSessionManager(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        Resource web = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
        ModelNode subModel = web.getModel();
        String host = VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
        String path = CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
        String server = SERVER.resolveModelAttribute(context, subModel).asString();
        ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
        if (controller == null || controller.getState() != ServiceController.State.UP) {
            throw UndertowLogger.ROOT_LOGGER.sessionManagerNotAvailable();
        }
        UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
        if (deploymentService == null || deploymentService.getDeployment() == null) {
            throw UndertowLogger.ROOT_LOGGER.sessionManagerNotAvailable();
        }
        Deployment deployment = deploymentService.getDeployment();
        return deployment.getSessionManager();
    }

    public static enum SessionStat {
        ACTIVE_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("active-sessions", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build()),
        EXPIRED_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("expired-sessions", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        SESSIONS_CREATED((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("sessions-created", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).setStorageRuntime()).build()),
        SESSION_AVG_ALIVE_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-avg-alive-time", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.SECONDS)).setStorageRuntime()).build()),
        SESSION_MAX_ALIVE_TIME((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("session-max-alive-time", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setMeasurementUnit(MeasurementUnit.SECONDS)).setStorageRuntime()).build()),
        REJECTED_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("rejected-sessions", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.COUNTER_METRIC})).build()),
        MAX_ACTIVE_SESSIONS((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("max-active-sessions", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build()),
        HIGHEST_SESSION_COUNT((AttributeDefinition)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("highest-session-count", ModelType.INT).setUndefinedMetricValue(ModelNode.ZERO)).setStorageRuntime()).build());

        private static final Map<String, SessionStat> MAP;
        final AttributeDefinition definition;

        private SessionStat(AttributeDefinition definition) {
            this.definition = definition;
        }

        public final String toString() {
            return this.definition.getName();
        }

        public static synchronized SessionStat getStat(String stringForm) {
            return MAP.get(stringForm);
        }

        static {
            MAP = new HashMap<String, SessionStat>();
            for (SessionStat stat : EnumSet.allOf(SessionStat.class)) {
                MAP.put(stat.toString(), stat);
            }
        }
    }

    static class SessionManagerStatsHandler
    extends AbstractRuntimeOnlyHandler {
        static SessionManagerStatsHandler INSTANCE = new SessionManagerStatsHandler();

        private SessionManagerStatsHandler() {
        }

        public static SessionManagerStatsHandler getInstance() {
            return INSTANCE;
        }

        protected void executeRuntimeStep(OperationContext context, ModelNode operation) throws OperationFailedException {
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size()), false);
            ModelNode subModel = web.getModel();
            String host = VIRTUAL_HOST.resolveModelAttribute(context, subModel).asString();
            String path = CONTEXT_ROOT.resolveModelAttribute(context, subModel).asString();
            String server = SERVER.resolveModelAttribute(context, subModel).asString();
            SessionStat stat = SessionStat.getStat(operation.require("name").asString());
            if (stat == null) {
                context.getFailureDescription().set(UndertowLogger.ROOT_LOGGER.unknownMetric(operation.require("name").asString()));
            } else {
                ModelNode result = new ModelNode();
                ServiceController controller = context.getServiceRegistry(false).getService(UndertowService.deploymentServiceName(server, host, path));
                if (controller == null || controller.getState() != ServiceController.State.UP) {
                    return;
                }
                UndertowDeploymentService deploymentService = (UndertowDeploymentService)controller.getService();
                if (deploymentService == null || deploymentService.getDeployment() == null) {
                    return;
                }
                Deployment deployment = deploymentService.getDeployment();
                SessionManager sessionManager = deployment.getSessionManager();
                SessionManagerStatistics sms = sessionManager.getStatistics();
                switch (stat) {
                    case ACTIVE_SESSIONS: {
                        result.set(sessionManager.getActiveSessions().size());
                        break;
                    }
                    case EXPIRED_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getExpiredSessionCount());
                        break;
                    }
                    case MAX_ACTIVE_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getMaxActiveSessions());
                        break;
                    }
                    case SESSIONS_CREATED: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getCreatedSessionCount());
                        break;
                    }
                    case SESSION_AVG_ALIVE_TIME: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getAverageSessionAliveTime() / 1000);
                        break;
                    }
                    case SESSION_MAX_ALIVE_TIME: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getMaxSessionAliveTime() / 1000);
                        break;
                    }
                    case REJECTED_SESSIONS: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getRejectedSessions());
                        break;
                    }
                    case HIGHEST_SESSION_COUNT: {
                        if (sms == null) {
                            result.set(0);
                            break;
                        }
                        result.set((int)sms.getHighestSessionCount());
                        break;
                    }
                    default: {
                        throw new IllegalStateException(UndertowLogger.ROOT_LOGGER.unknownMetric((Object)stat));
                    }
                }
                context.getResult().set(result);
            }
        }
    }

    static class SessionManagerOperationHandler
    extends AbstractRuntimeOnlyHandler {
        SessionManagerOperationHandler() {
        }

        protected void executeRuntimeStep(OperationContext operationContext, ModelNode modelNode) throws OperationFailedException {
            ModelNode result = new ModelNode();
            SessionManager sessionManager = DeploymentDefinition.getSessionManager(operationContext, modelNode);
            String name = modelNode.get("operation").asString();
            if (name.equals("list-sessions")) {
                result.setEmptyList();
                Set sessions = sessionManager.getAllSessions();
                for (String s : sessions) {
                    result.add(s);
                }
                operationContext.getResult().set(result);
                return;
            }
            String sessionId = SESSIOND_ID.resolveModelAttribute(operationContext, modelNode).asString();
            Session session = sessionManager.getSession(sessionId);
            if (session == null && !name.equals("invalidate-session")) {
                throw UndertowLogger.ROOT_LOGGER.sessionNotFound(sessionId);
            }
            switch (name) {
                case "invalidate-session": {
                    if (session == null) {
                        result.set(false);
                        break;
                    }
                    session.invalidate(null);
                    result.set(true);
                    break;
                }
                case "list-session-attribute-names": {
                    result.setEmptyList();
                    Set sessions = session.getAttributeNames();
                    for (String s : sessions) {
                        result.add(s);
                    }
                    break;
                }
                case "list-session-attributes": {
                    result.setEmptyList();
                    Set sessions = session.getAttributeNames();
                    for (String s : sessions) {
                        Object attribute = session.getAttribute(s);
                        ModelNode m = new ModelNode();
                        if (attribute != null) {
                            m.set(attribute.toString());
                        }
                        result.add(new Property(s, m));
                    }
                    break;
                }
                case "get-session-attribute": {
                    String a = ATTRIBUTE.resolveModelAttribute(operationContext, modelNode).asString();
                    Object attribute = session.getAttribute(a);
                    if (attribute == null) break;
                    result.set(attribute.toString());
                    break;
                }
                case "get-session-last-accessed-time": {
                    long accessTime = session.getLastAccessedTime();
                    result.set(DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(accessTime)));
                    break;
                }
                case "get-session-last-accessed-time-millis": {
                    long accessTime = session.getLastAccessedTime();
                    result.set(accessTime);
                    break;
                }
                case "get-session-creation-time": {
                    long accessTime = session.getCreationTime();
                    result.set(DateTimeFormatter.ISO_DATE_TIME.withZone(ZoneId.systemDefault()).format(Instant.ofEpochMilli(accessTime)));
                    break;
                }
                case "get-session-creation-time-millis": {
                    long accessTime = session.getCreationTime();
                    result.set(accessTime);
                    break;
                }
            }
            operationContext.getResult().set(result);
        }
    }
}

