/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.wasm.api;

import org.wildfly.wasm.api.DefaultWasmTools;
import org.wildfly.wasm.api.WasmArgumentSerializer;
import org.wildfly.wasm.api.WasmInvoker;
import org.wildfly.wasm.api.WasmResultDeserializer;
import org.wildfly.wasm.api.WasmToolContext;

public abstract class WasmTools<T> {
    protected final WasmToolContext context;

    public WasmTools(WasmToolContext context) {
        this.context = context;
    }

    public static <T> T create(Class<T> wasmTool, String methodName, WasmArgumentSerializer wasmArgumentSerializer, WasmResultDeserializer wasmResultDeserializer, WasmInvoker invoker) {
        return WasmTools.builder(wasmTool, methodName, wasmArgumentSerializer, wasmResultDeserializer).wasmInvoker(invoker).build();
    }

    public static <T> WasmTools<T> builder(Class<T> wasmTool, String methodName, WasmArgumentSerializer wasmArgumentSerializer, WasmResultDeserializer wasmResultDeserializer) {
        WasmToolContext context = new WasmToolContext(wasmTool, methodName, wasmArgumentSerializer, wasmResultDeserializer);
        return new DefaultWasmTools(context);
    }

    public WasmTools<T> wasmInvoker(WasmInvoker invoker) {
        this.context.wasmInvoker(invoker);
        return this;
    }

    public abstract T build();
}

