/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.wasm.injection;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.AfterBeanDiscovery;
import jakarta.enterprise.inject.spi.Extension;
import jakarta.enterprise.inject.spi.ProcessAnnotatedType;
import jakarta.enterprise.inject.spi.WithAnnotations;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.wildfly.wasm.api.WasmArgumentSerializer;
import org.wildfly.wasm.api.WasmInvoker;
import org.wildfly.wasm.api.WasmResultDeserializer;
import org.wildfly.wasm.api.WasmTool;
import org.wildfly.wasm.api.WasmToolService;
import org.wildfly.wasm.api.WasmTools;

public class WasmServicePortableExtension
implements Extension {
    private static final Set<Class<?>> detectedWasmServicesDeclaredInterfaces = new HashSet();
    private final Set<Annotation> qualifiers = new HashSet<Annotation>();

    public WasmServicePortableExtension(Annotation ... qualifiers) {
        this.qualifiers.add((Annotation)Default.Literal.INSTANCE);
        this.qualifiers.addAll(Arrays.asList(qualifiers));
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={WasmToolService.class}) ProcessAnnotatedType<T> pat) {
        if (pat.getAnnotatedType().getJavaClass().isInterface()) {
            detectedWasmServicesDeclaredInterfaces.add(pat.getAnnotatedType().getJavaClass());
        } else {
            System.out.println("processAnnotatedType reject " + pat.getAnnotatedType().getJavaClass().getName() + " which is not an interface");
            pat.veto();
        }
    }

    public void atd(@Observes AfterBeanDiscovery atd) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException, IllegalArgumentException, InvocationTargetException {
        for (Class<?> wasmToolServiceClass : detectedWasmServicesDeclaredInterfaces) {
            System.out.println("afterBeanDiscovery create synthetic:  " + wasmToolServiceClass.getName() + " " + String.valueOf(wasmToolServiceClass.getClassLoader()));
            Class wasmArgumentSerializerClass = wasmToolServiceClass.getAnnotation(WasmToolService.class).argumentSerializer();
            WasmArgumentSerializer wasmArgumentSerializer = wasmArgumentSerializerClass != null && !wasmArgumentSerializerClass.isInterface() ? (WasmArgumentSerializer)wasmArgumentSerializerClass.getConstructor(new Class[0]).newInstance(new Object[0]) : WasmArgumentSerializer.DEFAULT;
            Class wasmResultDeserializerClass = wasmToolServiceClass.getAnnotation(WasmToolService.class).resultDeserializer();
            WasmResultDeserializer wasmResultDeserializer = wasmResultDeserializerClass != null && !wasmResultDeserializerClass.isInterface() ? (WasmResultDeserializer)wasmResultDeserializerClass.getConstructor(new Class[0]).newInstance(new Object[0]) : WasmResultDeserializer.DEFAULT;
            atd.addBean().scope(ApplicationScoped.class).addQualifiers(this.qualifiers).beanClass(wasmToolServiceClass).types(new Type[]{wasmToolServiceClass}).produceWith(lookup -> {
                String invokerName = wasmToolServiceClass.getAnnotation(WasmToolService.class).wasmToolConfigurationName();
                String methodName = wasmToolServiceClass.getAnnotation(WasmToolService.class).wasmMethodName();
                WasmInvoker invoker = (WasmInvoker)lookup.select(WasmInvoker.class, new Annotation[]{WasmTool.WasmToolLiteral.of((String)invokerName)}).get();
                return WasmTools.create((Class)wasmToolServiceClass, (String)methodName, (WasmArgumentSerializer)wasmArgumentSerializer, (WasmResultDeserializer)wasmResultDeserializer, (WasmInvoker)invoker);
            });
        }
    }
}

