/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.sasl.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;
import javax.security.sasl.SaslServer;
import javax.security.sasl.SaslServerFactory;

public final class AggregateSaslServerFactory
implements SaslServerFactory {
    private final SaslServerFactory[] factories;

    public AggregateSaslServerFactory(SaslServerFactory ... factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories is null");
        }
        this.factories = (SaslServerFactory[])factories.clone();
    }

    public AggregateSaslServerFactory(Collection<SaslServerFactory> factories) {
        if (factories == null) {
            throw new IllegalArgumentException("factories is null");
        }
        this.factories = factories.toArray(new SaslServerFactory[factories.size()]);
    }

    @Override
    public SaslServer createSaslServer(String mechanism, String protocol, String serverName, Map<String, ?> props, CallbackHandler cbh) throws SaslException {
        for (SaslServerFactory factory : this.factories) {
            SaslServer saslServer;
            if (factory == null || (saslServer = factory.createSaslServer(mechanism, protocol, serverName, props, cbh)) == null) continue;
            return saslServer;
        }
        return null;
    }

    @Override
    public String[] getMechanismNames(Map<String, ?> props) {
        LinkedHashSet names = new LinkedHashSet();
        for (SaslServerFactory factory : this.factories) {
            Collections.addAll(names, factory.getMechanismNames(props));
        }
        return names.toArray(new String[names.size()]);
    }
}

