/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.transform.AbstractOperationTransformer;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.dmr.ModelNode;

class LoggingOperationTransformer
extends AbstractOperationTransformer {
    static final LoggingOperationTransformer INSTANCE = new LoggingOperationTransformer();

    LoggingOperationTransformer() {
    }

    protected ModelNode transform(TransformationContext context, PathAddress address, ModelNode operation) {
        String key = address.getLastElement().getKey();
        String name = address.getLastElement().getValue();
        String operationName = operation.get("operation").asString();
        ModelNode originalOperation = operation.clone();
        if (operationName.equals("add-handler")) {
            if (key.equals("root-logger")) {
                operation.get("operation").set("root-logger-assign-handler");
            } else if (key.equals("logger")) {
                operation.get("operation").set("assign-handler");
            } else if (key.equals("async-handler")) {
                operation.get("operation").set("assign-subhandler");
            }
        } else if (operationName.equals("remove-handler")) {
            if (key.equals("root-logger")) {
                operation.get("operation").set("root-logger-unassign-handler");
            } else if (key.equals("logger")) {
                operation.get("operation").set("unassign-handler");
            } else if (key.equals("async-handler")) {
                operation.get("operation").set("unassign-subhandler");
            }
        } else if (operationName.equals("add")) {
            if ("logger".equals(key)) {
                operation.get(LoggerResourceDefinition.CATEGORY.getName()).set(name);
            } else if (!"root-logger".equals(key)) {
                operation.get(CommonAttributes.NAME.getName()).set(name);
            }
        } else if (operationName.equals("set-root-logger")) {
            operation.remove(CommonAttributes.NAME.getName());
        }
        LoggingLogger.ROOT_LOGGER.tracef("Changed operation from: %s%nto: %s", originalOperation, operation);
        return operation;
    }
}

