/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.AttributeMarshaller;
import org.jboss.as.controller.DefaultAttributeMarshaller;
import org.jboss.as.controller.ObjectTypeAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.logging.KnownModelVersion;
import org.jboss.as.logging.Logging;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.LoggingOperations;
import org.jboss.as.logging.PropertyAttributeDefinition;
import org.jboss.as.logging.TransformerResourceDefinition;
import org.jboss.as.logging.logging.LoggingLogger;
import org.jboss.as.logging.validators.RegexValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;
import org.jboss.logmanager.formatters.PatternFormatter;

public class PatternFormatterResourceDefinition
extends TransformerResourceDefinition {
    static final String COLOR_MAP_VALIDATION_PATTERN = "^((severe|fatal|error|warn|warning|info|debug|trace|config|fine|finer|finest|):(clear|black|green|red|yellow|blue|magenta|cyan|white|brightblack|brightred|brightgreen|brightblue|brightyellow|brightmagenta|brightcyan|brightwhite|)(,(?!$)|$))*$";
    public static final PropertyAttributeDefinition COLOR_MAP = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("color-map", ModelType.STRING).setAllowExpression(true)).setAllowNull(true)).setPropertyName("colors").setValidator((ParameterValidator)new RegexValidator(ModelType.STRING, true, true, "^((severe|fatal|error|warn|warning|info|debug|trace|config|fine|finer|finest|):(clear|black|green|red|yellow|blue|magenta|cyan|white|brightblack|brightred|brightgreen|brightblue|brightyellow|brightmagenta|brightcyan|brightwhite|)(,(?!$)|$))*$"))).build();
    public static final PropertyAttributeDefinition PATTERN = ((PropertyAttributeDefinition.Builder)((PropertyAttributeDefinition.Builder)PropertyAttributeDefinition.Builder.of("pattern", ModelType.STRING, true).setAllowExpression(true)).setDefaultValue(new ModelNode("%d{HH:mm:ss,SSS} %-5p [%c] (%t) %s%e%n"))).build();
    public static final ObjectTypeAttributeDefinition PATTERN_FORMATTER = ((ObjectTypeAttributeDefinition.Builder)((ObjectTypeAttributeDefinition.Builder)ObjectTypeAttributeDefinition.Builder.of((String)"pattern-formatter", (AttributeDefinition[])new AttributeDefinition[]{PATTERN, COLOR_MAP}).setAllowExpression(false)).setAllowNull(true).setAttributeMarshaller((AttributeMarshaller)new DefaultAttributeMarshaller(){

        public void marshallAsElement(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault, XMLStreamWriter writer) throws XMLStreamException {
            if (this.isMarshallable(attribute, resourceModel, marshallDefault)) {
                writer.writeStartElement(attribute.getXmlName());
                String pattern = resourceModel.get(PATTERN.getName()).asString();
                writer.writeAttribute(PATTERN.getXmlName(), pattern);
                if (resourceModel.hasDefined(COLOR_MAP.getName())) {
                    String colorMap = resourceModel.get(COLOR_MAP.getName()).asString();
                    writer.writeAttribute(COLOR_MAP.getXmlName(), colorMap);
                }
                writer.writeEndElement();
            }
        }

        public boolean isMarshallable(AttributeDefinition attribute, ModelNode resourceModel, boolean marshallDefault) {
            return resourceModel.hasDefined(PATTERN.getName());
        }
    })).build();
    static final PathElement PATTERN_FORMATTER_PATH = PathElement.pathElement((String)PATTERN_FORMATTER.getName());
    static final PropertyAttributeDefinition[] ATTRIBUTES = new PropertyAttributeDefinition[]{COLOR_MAP, PATTERN};
    static final OperationStepHandler ADD = new LoggingOperations.LoggingAddOperationStepHandler(){

        @Override
        public void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            for (PropertyAttributeDefinition attribute : ATTRIBUTES) {
                attribute.validateAndSet(operation, model);
            }
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                LoggingLogger.ROOT_LOGGER.tracef("Adding formatter '%s' at '%s'", name, LoggingOperations.getAddress(operation));
                configuration = logContextConfiguration.addFormatterConfiguration(null, PatternFormatter.class.getName(), name, new String[0]);
            }
            for (PropertyAttributeDefinition attribute : ATTRIBUTES) {
                attribute.setPropertyValue(context, model, (PropertyConfigurable)configuration);
            }
        }
    };
    static final OperationStepHandler WRITE = new LoggingOperations.LoggingWriteAttributeHandler((AttributeDefinition[])ATTRIBUTES){

        @Override
        protected boolean applyUpdate(OperationContext context, String attributeName, String addressName, ModelNode value, LogContextConfiguration logContextConfiguration) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(addressName);
            for (PropertyAttributeDefinition attribute : ATTRIBUTES) {
                if (!attribute.getName().equals(attributeName)) continue;
                configuration.setPropertyValueString(attribute.getPropertyName(), value.asString());
                break;
            }
            return false;
        }
    };
    static final OperationStepHandler REMOVE = new LoggingOperations.LoggingRemoveOperationStepHandler(){

        @Override
        protected void performRemove(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            context.removeResource(PathAddress.EMPTY_ADDRESS);
        }

        @Override
        public void performRuntime(OperationContext context, ModelNode operation, LogContextConfiguration logContextConfiguration, String name, ModelNode model) throws OperationFailedException {
            FormatterConfiguration configuration = logContextConfiguration.getFormatterConfiguration(name);
            if (configuration == null) {
                throw Logging.createOperationFailure(LoggingLogger.ROOT_LOGGER.formatterNotFound(name));
            }
            logContextConfiguration.removeFormatterConfiguration(name);
        }
    };
    static final PatternFormatterResourceDefinition INSTANCE = new PatternFormatterResourceDefinition();

    public PatternFormatterResourceDefinition() {
        super(PATTERN_FORMATTER_PATH, LoggingExtension.getResourceDescriptionResolver(PATTERN_FORMATTER.getName()), ADD, REMOVE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (PropertyAttributeDefinition def : ATTRIBUTES) {
            resourceRegistration.registerReadWriteAttribute((AttributeDefinition)def, null, WRITE);
        }
    }

    @Override
    public void registerTransformers(KnownModelVersion modelVersion, ResourceTransformationDescriptionBuilder resourceBuilder, ResourceTransformationDescriptionBuilder loggingProfileBuilder) {
        switch (modelVersion) {
            case VERSION_1_3_0: {
                resourceBuilder.rejectChildResource(PATTERN_FORMATTER_PATH);
                if (loggingProfileBuilder == null) break;
                loggingProfileBuilder.rejectChildResource(PATTERN_FORMATTER_PATH);
            }
        }
    }
}

