/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow.deployment;

import io.undertow.util.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.MountedDeploymentOverlay;
import org.jboss.as.server.deployment.PrivateSubDeploymentMarker;
import org.jboss.as.server.deployment.module.FilterSpecification;
import org.jboss.as.server.deployment.module.ModuleRootMarker;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.MountHandle;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.deployment.module.TempFileProviderService;
import org.jboss.as.web.common.SharedTldsMetaDataBuilder;
import org.jboss.as.web.common.WarMetaData;
import org.jboss.metadata.web.spec.WebMetaData;
import org.jboss.modules.filter.PathFilters;
import org.jboss.modules.security.ImmediatePermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;
import org.jboss.vfs.VisitorAttributes;
import org.jboss.vfs.util.SuffixMatchFilter;
import org.wildfly.extension.undertow.deployment.TldsMetaData;
import org.wildfly.extension.undertow.deployment.UndertowAttachments;
import org.wildfly.extension.undertow.logging.UndertowLogger;

public class WarStructureDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final String TEMP_DIR = "jboss.server.temp.dir";
    public static final String WEB_INF_LIB = "WEB-INF/lib";
    public static final String WEB_INF_CLASSES = "WEB-INF/classes";
    public static final String META_INF = "META-INF";
    private static final String WEB_INF_EXTERNAL_MOUNTS = "WEB-INF/undertow-external-mounts.conf";
    public static final VirtualFileFilter DEFAULT_WEB_INF_LIB_FILTER = new SuffixMatchFilter(".jar", VisitorAttributes.DEFAULT);
    private final WebMetaData sharedWebMetaData;
    private final SharedTldsMetaDataBuilder sharedTldsMetaData;

    public WarStructureDeploymentProcessor(WebMetaData sharedWebMetaData, SharedTldsMetaDataBuilder sharedTldsMetaData) {
        this.sharedWebMetaData = sharedWebMetaData;
        this.sharedTldsMetaData = sharedTldsMetaData;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!DeploymentTypeMarker.isType((DeploymentType)DeploymentType.WAR, (DeploymentUnit)deploymentUnit)) {
            return;
        }
        ResourceRoot deploymentResourceRoot = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        VirtualFile deploymentRoot = deploymentResourceRoot.getRoot();
        if (deploymentRoot == null) {
            return;
        }
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        if (moduleSpecification == null) {
            return;
        }
        moduleSpecification.setPrivateModule(true);
        PrivateSubDeploymentMarker.mark((DeploymentUnit)deploymentUnit);
        if (!deploymentUnit.hasAttachment(Attachments.OSGI_MANIFEST) || deploymentRoot.getChild(WEB_INF_CLASSES).exists()) {
            deploymentResourceRoot.putAttachment(Attachments.INDEX_RESOURCE_ROOT, (Object)false);
            deploymentResourceRoot.getExportFilters().add(new FilterSpecification(PathFilters.getMetaInfFilter(), true));
            deploymentResourceRoot.getExportFilters().add(new FilterSpecification(PathFilters.getMetaInfSubdirectoriesFilter(), true));
            deploymentResourceRoot.getExportFilters().add(new FilterSpecification(PathFilters.acceptAll(), false));
            ModuleRootMarker.mark((ResourceRoot)deploymentResourceRoot, (boolean)true);
        }
        MountHandle mountHandle = deploymentResourceRoot.getMountHandle();
        try {
            List<ResourceRoot> resourceRoots = this.createResourceRoots(deploymentRoot, deploymentUnit);
            for (ResourceRoot root : resourceRoots) {
                deploymentUnit.addToAttachmentList(Attachments.RESOURCE_ROOTS, (Object)root);
            }
        }
        catch (Exception e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        WarMetaData warMetaData = new WarMetaData();
        warMetaData.setSharedWebMetaData(this.sharedWebMetaData);
        deploymentUnit.putAttachment(WarMetaData.ATTACHMENT_KEY, (Object)warMetaData);
        String deploymentName = deploymentUnit.getParent() == null ? deploymentUnit.getName() : deploymentUnit.getParent().getName() + "." + deploymentUnit.getName();
        PathManager pathManager = (PathManager)deploymentUnit.getAttachment(Attachments.PATH_MANAGER);
        File tempDir = new File(pathManager.getPathEntry(TEMP_DIR).resolvePath(), deploymentName);
        tempDir.mkdirs();
        warMetaData.setTempDir(tempDir);
        moduleSpecification.addPermissionFactory((PermissionFactory)new ImmediatePermissionFactory((Permission)new FilePermission(tempDir.getAbsolutePath() + File.separatorChar + "-", "read,write,delete")));
        TldsMetaData tldsMetaData = new TldsMetaData();
        tldsMetaData.setSharedTlds(this.sharedTldsMetaData);
        deploymentUnit.putAttachment(TldsMetaData.ATTACHMENT_KEY, (Object)tldsMetaData);
        this.processExternalMounts(deploymentUnit, deploymentRoot);
    }

    private void processExternalMounts(DeploymentUnit deploymentUnit, VirtualFile deploymentRoot) throws DeploymentUnitProcessingException {
        VirtualFile mounts = deploymentRoot.getChild(WEB_INF_EXTERNAL_MOUNTS);
        if (!mounts.exists()) {
            return;
        }
        try (InputStream data = mounts.openStream();){
            String[] lines;
            String contents = FileUtils.readFile((InputStream)data);
            for (String line : lines = contents.split("\n")) {
                String trimmed = line;
                int commentIndex = trimmed.indexOf("#");
                if (commentIndex > -1) {
                    trimmed = trimmed.substring(0, commentIndex);
                }
                if ((trimmed = trimmed.trim()).isEmpty()) continue;
                File path = new File(trimmed);
                if (path.exists()) {
                    deploymentUnit.addToAttachmentList(UndertowAttachments.EXTERNAL_RESOURCES, (Object)path);
                    continue;
                }
                throw UndertowLogger.ROOT_LOGGER.couldNotFindExternalPath(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private List<ResourceRoot> createResourceRoots(VirtualFile deploymentRoot, DeploymentUnit deploymentUnit) throws IOException, DeploymentUnitProcessingException {
        ArrayList<ResourceRoot> entries = new ArrayList<ResourceRoot>();
        VirtualFile webinfClasses = deploymentRoot.getChild(WEB_INF_CLASSES);
        if (webinfClasses.exists()) {
            ResourceRoot webInfClassesRoot = new ResourceRoot(webinfClasses.getName(), webinfClasses, null);
            ModuleRootMarker.mark((ResourceRoot)webInfClassesRoot);
            entries.add(webInfClassesRoot);
        }
        Map overlays = (Map)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_OVERLAY_LOCATIONS);
        VirtualFile webinfLib = deploymentRoot.getChild(WEB_INF_LIB);
        if (webinfLib.exists()) {
            List archives = webinfLib.getChildren(DEFAULT_WEB_INF_LIB_FILTER);
            for (VirtualFile archive : archives) {
                try {
                    String relativeName = archive.getPathNameRelativeTo(deploymentRoot);
                    MountedDeploymentOverlay overlay = (MountedDeploymentOverlay)overlays.get(relativeName);
                    Closeable closable = null;
                    if (overlay != null) {
                        overlay.remountAsZip(false);
                    } else {
                        closable = archive.isFile() ? VFS.mountZip((VirtualFile)archive, (VirtualFile)archive, (TempFileProvider)TempFileProviderService.provider()) : null;
                    }
                    ResourceRoot webInfArchiveRoot = new ResourceRoot(archive.getName(), archive, new MountHandle(closable));
                    ModuleRootMarker.mark((ResourceRoot)webInfArchiveRoot);
                    entries.add(webInfArchiveRoot);
                }
                catch (IOException e) {
                    throw new DeploymentUnitProcessingException(UndertowLogger.ROOT_LOGGER.failToProcessWebInfLib(archive), (Throwable)e);
                }
            }
        }
        return entries;
    }
}

