/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.callback;

import java.security.spec.AlgorithmParameterSpec;
import org.wildfly.security.auth.callback.ExtendedCallback;

public class ParameterCallback
implements ExtendedCallback {
    private final Class<? extends AlgorithmParameterSpec>[] allowedTypes;
    private AlgorithmParameterSpec parameterSpec;

    @SafeVarargs
    public ParameterCallback(Class<? extends AlgorithmParameterSpec> ... allowedTypes) {
        this.allowedTypes = allowedTypes;
    }

    @SafeVarargs
    public ParameterCallback(AlgorithmParameterSpec parameterSpec, Class<? extends AlgorithmParameterSpec> ... allowedTypes) {
        this.allowedTypes = allowedTypes;
        this.parameterSpec = parameterSpec;
    }

    public AlgorithmParameterSpec getParameterSpec() {
        return this.parameterSpec;
    }

    public void setParameterSpec(AlgorithmParameterSpec parameterSpec) {
        if (!this.isParameterSupported(parameterSpec)) {
            throw new IllegalArgumentException("Invalid credential type specified");
        }
        this.parameterSpec = parameterSpec;
    }

    public boolean isParameterSupported(AlgorithmParameterSpec parameterSpec) {
        for (Class<? extends AlgorithmParameterSpec> allowedType : this.allowedTypes) {
            if (!allowedType.isInstance(parameterSpec)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterTypeSupported(Class<? extends AlgorithmParameterSpec> parameterType) {
        for (Class<? extends AlgorithmParameterSpec> allowedType : this.allowedTypes) {
            if (!allowedType.isAssignableFrom(parameterType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isOptional() {
        return this.parameterSpec != null;
    }

    @Override
    public boolean needsInformation() {
        return true;
    }
}

