/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.security.auth.util;

import java.util.regex.Pattern;
import org.wildfly.security.auth.util.NameRewriter;

public final class RegexNameValidatingRewriter
implements NameRewriter {
    private final Pattern pattern;
    private final boolean match;

    public RegexNameValidatingRewriter(Pattern pattern, boolean match) {
        this.pattern = pattern;
        this.match = match;
    }

    @Override
    public String rewriteName(String original) throws IllegalArgumentException {
        if (this.pattern.matcher(original).find() != this.match) {
            throw new IllegalArgumentException("Invalid name");
        }
        return original;
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public boolean isMatch() {
        return this.match;
    }
}

