/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.console;

import java.io.IOException;
import org.jboss.aesh.console.Console;
import org.jboss.aesh.console.ConsoleOutput;
import org.jboss.aesh.console.operator.ControlOperator;
import org.jboss.aesh.edit.actions.Operation;

public abstract class ConsoleCommand {
    boolean attached = false;
    protected Console console = null;
    ConsoleOutput consoleOutput;

    public ConsoleCommand(Console console) {
        this.console = console;
    }

    public final void attach(ConsoleOutput output) throws IOException {
        this.attached = true;
        this.console.attachProcess(this);
        this.consoleOutput = output;
        this.afterAttach();
    }

    public final boolean isAttached() {
        return this.attached;
    }

    public final void detach() throws IOException {
        this.attached = false;
        this.afterDetach();
    }

    public final boolean hasRedirectOut() {
        return ControlOperator.isRedirectionOut(this.consoleOutput.getControlOperator());
    }

    public final ConsoleOutput getConsoleOutput() {
        return this.consoleOutput;
    }

    protected abstract void afterAttach() throws IOException;

    protected abstract void afterDetach() throws IOException;

    public abstract void processOperation(Operation var1) throws IOException;
}

