/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.operation.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.cli.CommandArgument;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineCompleter;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.impl.AttributeNamePathCompleter;
import org.jboss.as.cli.impl.ValueTypeCompleter;
import org.jboss.as.cli.operation.OperationCandidatesProvider;
import org.jboss.as.cli.operation.OperationFormatException;
import org.jboss.as.cli.operation.OperationRequestAddress;
import org.jboss.as.cli.operation.OperationRequestHeader;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.operation.impl.ChildTypeCompleter;
import org.jboss.as.cli.operation.impl.DefaultCallbackHandler;
import org.jboss.as.cli.operation.impl.DefaultOperationRequestBuilder;
import org.jboss.as.cli.operation.impl.OperationNameCompleter;
import org.jboss.as.cli.operation.impl.RolloutPlanRequestHeader;
import org.jboss.as.cli.operation.impl.SimpleDependentValueCompleter;
import org.jboss.as.cli.parsing.ParserUtil;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class DefaultOperationCandidatesProvider
implements OperationCandidatesProvider {
    private static final CommandLineCompleter BOOLEAN_HEADER_COMPLETER = new CommandLineCompleter(){
        private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                ParserUtil.parseHeaders(buffer, this.parsedOp);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            if (this.parsedOp.endsOnSeparator()) {
                candidates.add("false");
                candidates.add("true");
                return buffer.length();
            }
            if (this.parsedOp.getLastHeader() == null) {
                candidates.add("=");
                return buffer.length();
            }
            int result = SimpleTabCompleter.BOOLEAN.complete(ctx, buffer.substring(this.parsedOp.getLastChunkIndex()), cursor, candidates);
            if (result < 0) {
                return result;
            }
            return this.parsedOp.getLastChunkIndex() + result;
        }
    };
    private static final CommandLineCompleter INT_HEADER_COMPLETER = new CommandLineCompleter(){
        private final DefaultCallbackHandler parsedOp = new DefaultCallbackHandler();

        @Override
        public int complete(CommandContext ctx, String buffer, int cursor, List<String> candidates) {
            try {
                ParserUtil.parseHeaders(buffer, this.parsedOp);
            }
            catch (CommandFormatException e) {
                return -1;
            }
            if (this.parsedOp.endsOnSeparator()) {
                return buffer.length();
            }
            if (this.parsedOp.getLastHeader() == null) {
                candidates.add("=");
                return buffer.length();
            }
            return buffer.length();
        }
    };
    private static final Map<String, OperationRequestHeader> HEADERS = new HashMap<String, OperationRequestHeader>();
    private static final Map<String, Map<String, CommandLineCompleterFactory>> globalOpPropCompleters;

    private static void addBooleanHeader(final String name) {
        OperationRequestHeader header = new OperationRequestHeader(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public CommandLineCompleter getCompleter() {
                return BOOLEAN_HEADER_COMPLETER;
            }
        };
        HEADERS.put(header.getName(), header);
    }

    private static void addIntHeader(final String name) {
        OperationRequestHeader header = new OperationRequestHeader(){

            @Override
            public String getName() {
                return name;
            }

            @Override
            public CommandLineCompleter getCompleter() {
                return INT_HEADER_COMPLETER;
            }
        };
        HEADERS.put(header.getName(), header);
    }

    public List<String> getNodeNames(CommandContext ctx, OperationRequestAddress prefix) {
        List<String> result;
        ModelNode request;
        ModelControllerClient client = ctx.getModelControllerClient();
        if (client == null) {
            return Collections.emptyList();
        }
        if (prefix.isEmpty()) {
            throw new IllegalArgumentException("The prefix must end on a type but it's empty.");
        }
        if (!prefix.endsOnType()) {
            throw new IllegalArgumentException("The prefix doesn't end on a type.");
        }
        DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(prefix);
        try {
            builder.setOperationName("read-children-names");
            builder.addProperty("child-type", prefix.getNodeType());
            request = builder.buildRequest();
        }
        catch (OperationFormatException e1) {
            throw new IllegalStateException("Failed to build operation", e1);
        }
        try {
            ModelNode outcome = client.execute(request);
            result = !Util.isSuccess(outcome) ? Collections.emptyList() : Util.getList(outcome);
        }
        catch (Exception e) {
            result = Collections.emptyList();
        }
        return result;
    }

    public List<String> getNodeTypes(CommandContext ctx, OperationRequestAddress prefix) {
        return Util.getNodeTypes(ctx.getModelControllerClient(), prefix);
    }

    public List<String> getOperationNames(CommandContext ctx, OperationRequestAddress prefix) {
        return Util.getOperationNames(ctx, prefix);
    }

    public List<CommandArgument> getProperties(CommandContext ctx, String operationName, OperationRequestAddress address) {
        List<CommandArgument> result;
        block19: {
            ModelNode request;
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                return Collections.emptyList();
            }
            DefaultOperationRequestBuilder builder = new DefaultOperationRequestBuilder(address);
            try {
                builder.setOperationName("read-operation-description");
                builder.addProperty("name", operationName);
                request = builder.buildRequest();
            }
            catch (OperationFormatException e1) {
                throw new IllegalStateException("Failed to build operation", e1);
            }
            Map<String, CommandLineCompleterFactory> globalOpProps = globalOpPropCompleters.get(operationName);
            try {
                ModelNode outcome = client.execute(request);
                if (!Util.isSuccess(outcome)) {
                    result = Collections.emptyList();
                    break block19;
                }
                ModelNode resultNode = outcome.get("result");
                if (!resultNode.isDefined()) {
                    return Collections.emptyList();
                }
                ModelNode reqProps = resultNode.get("request-properties");
                if (!reqProps.isDefined()) {
                    return Collections.emptyList();
                }
                List propList = reqProps.asPropertyList();
                result = new ArrayList<CommandArgument>(propList.size());
                for (final Property prop : propList) {
                    CommandLineCompleterFactory factory = globalOpProps == null ? null : globalOpProps.get(prop.getName());
                    CommandLineCompleter propCompleter = null;
                    if (factory != null) {
                        propCompleter = factory.createCompleter(address);
                    } else {
                        ModelNode typeNode = prop.getValue().get("type");
                        if (typeNode.isDefined() && typeNode.asType().equals((Object)ModelType.BOOLEAN)) {
                            propCompleter = SimpleTabCompleter.BOOLEAN;
                        } else if (prop.getValue().has("value-type")) {
                            ModelNode valueTypeNode = prop.getValue().get("value-type");
                            try {
                                valueTypeNode.asType();
                                if (prop.getValue().has("allowed")) {
                                    propCompleter = this.getAllowedCompleter(prop);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                propCompleter = new ValueTypeCompleter(prop.getValue());
                            }
                        } else if (prop.getValue().has("allowed")) {
                            propCompleter = this.getAllowedCompleter(prop);
                        }
                    }
                    final CommandLineCompleter completer = propCompleter;
                    result.add(new CommandArgument(){
                        final String argName;
                        {
                            this.argName = prop.getName();
                        }

                        @Override
                        public String getFullName() {
                            return this.argName;
                        }

                        @Override
                        public String getShortName() {
                            return null;
                        }

                        @Override
                        public int getIndex() {
                            return -1;
                        }

                        @Override
                        public boolean isPresent(ParsedCommandLine args) throws CommandFormatException {
                            return args.hasProperty(this.argName);
                        }

                        @Override
                        public boolean canAppearNext(CommandContext ctx) throws CommandFormatException {
                            return !this.isPresent(ctx.getParsedCommandLine());
                        }

                        @Override
                        public String getValue(ParsedCommandLine args) throws CommandFormatException {
                            return args.getPropertyValue(this.argName);
                        }

                        @Override
                        public String getValue(ParsedCommandLine args, boolean required) throws CommandFormatException {
                            if (!this.isPresent(args)) {
                                throw new CommandFormatException("Property '" + this.argName + "' is missing required value.");
                            }
                            return args.getPropertyValue(this.argName);
                        }

                        @Override
                        public boolean isValueComplete(ParsedCommandLine args) throws CommandFormatException {
                            if (!this.isPresent(args)) {
                                return false;
                            }
                            return !this.argName.equals(args.getLastParsedPropertyName());
                        }

                        @Override
                        public boolean isValueRequired() {
                            return true;
                        }

                        @Override
                        public CommandLineCompleter getValueCompleter() {
                            return completer;
                        }
                    });
                }
            }
            catch (Exception e) {
                result = Collections.emptyList();
            }
        }
        return result;
    }

    private CommandLineCompleter getAllowedCompleter(Property prop) {
        ModelNode allowedNode = prop.getValue().get("allowed");
        if (allowedNode.isDefined()) {
            List nodeList = allowedNode.asList();
            String[] values = new String[nodeList.size()];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ((ModelNode)nodeList.get(i)).asString();
            }
            return new SimpleTabCompleter(values);
        }
        return null;
    }

    @Override
    public Map<String, OperationRequestHeader> getHeaders(CommandContext ctx) {
        return HEADERS;
    }

    static void addGlobalOpPropCompleter(String op, String prop, CommandLineCompleterFactory factory) {
        Map<String, CommandLineCompleterFactory> propMap = globalOpPropCompleters.get(op);
        if (propMap == null) {
            propMap = new HashMap<String, CommandLineCompleterFactory>();
            globalOpPropCompleters.put(op, propMap);
        }
        propMap.put(prop, factory);
    }

    static CommandLineCompleterFactory getGlobalOpPropCompleter(String op, String prop) {
        Map<String, CommandLineCompleterFactory> propMap = globalOpPropCompleters.get(op);
        return propMap == null ? null : propMap.get(prop);
    }

    static {
        HEADERS.put(RolloutPlanRequestHeader.INSTANCE.getName(), RolloutPlanRequestHeader.INSTANCE);
        DefaultOperationCandidatesProvider.addBooleanHeader("allow-resource-service-restart");
        DefaultOperationCandidatesProvider.addBooleanHeader("rollback-on-runtime-failure");
        DefaultOperationCandidatesProvider.addIntHeader("blocking-timeout");
        globalOpPropCompleters = new HashMap<String, Map<String, CommandLineCompleterFactory>>();
        CommandLineCompleterFactory attrNameCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address);
            }
        };
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("undefine-attribute", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-attribute", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("write-attribute", "name", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(OperationRequestAddress address) {
                return new AttributeNamePathCompleter(address, true);
            }
        });
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("write-attribute", "value", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(OperationRequestAddress address) {
                return new SimpleDependentValueCompleter(address, "name");
            }
        });
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-operation-description", "name", new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(OperationRequestAddress address) {
                return new OperationNameCompleter(address);
            }
        });
        CommandLineCompleterFactory childTypeCompleter = new CommandLineCompleterFactory(){

            @Override
            public CommandLineCompleter createCompleter(OperationRequestAddress address) {
                return new ChildTypeCompleter(address);
            }
        };
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-children-names", "child-type", childTypeCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("read-children-resources", "child-type", childTypeCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-put", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-remove", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-get", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("map-clear", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-add", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-remove", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-get", "name", attrNameCompleter);
        DefaultOperationCandidatesProvider.addGlobalOpPropCompleter("list-clear", "name", attrNameCompleter);
    }

    static interface CommandLineCompleterFactory {
        public CommandLineCompleter createCompleter(OperationRequestAddress var1);
    }
}

