/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.HashSet;
import java.util.List;
import javax.security.auth.Subject;
import org.jboss.as.controller.remote.TransactionalProtocolClient;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.logging.DomainControllerLogger;
import org.jboss.as.domain.controller.plan.AbstractServerGroupRolloutTask;
import org.jboss.as.domain.controller.plan.ServerTaskExecutor;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ServerUpdateTask;

class ConcurrentServerGroupUpdateTask
extends AbstractServerGroupRolloutTask
implements Runnable {
    public ConcurrentServerGroupUpdateTask(List<ServerUpdateTask> tasks, ServerUpdatePolicy updatePolicy, ServerTaskExecutor executor, Subject subject) {
        super(tasks, updatePolicy, executor, subject);
    }

    @Override
    public void execute() {
        ServerIdentity identity2;
        HashSet<ServerIdentity> outstanding = new HashSet<ServerIdentity>();
        ServerTaskExecutor.ServerOperationListener listener = new ServerTaskExecutor.ServerOperationListener();
        for (ServerUpdateTask task : this.tasks) {
            identity2 = task.getServerIdentity();
            if (this.updatePolicy.canUpdateServer(identity2) && !Thread.currentThread().isInterrupted()) {
                if (!this.executor.executeTask((TransactionalProtocolClient.TransactionalOperationListener<ServerTaskExecutor.ServerOperation>)listener, task)) continue;
                outstanding.add(task.getServerIdentity());
                continue;
            }
            DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.tracef("Skipping server update task for %s", identity2);
        }
        boolean interrupted = false;
        while (!interrupted && !outstanding.isEmpty()) {
            try {
                TransactionalProtocolClient.PreparedOperation prepared = listener.retrievePreparedOperation();
                identity2 = ((ServerTaskExecutor.ServerOperation)prepared.getOperation()).getIdentity();
                this.recordPreparedOperation(identity2, (TransactionalProtocolClient.PreparedOperation<ServerTaskExecutor.ServerOperation>)prepared);
                outstanding.remove(identity2);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
        }
        if (!outstanding.isEmpty()) {
            DomainControllerLogger.DOMAIN_DEPLOYMENT_LOGGER.interruptedAwaitingPreparedResponse(this.getClass().getSimpleName(), outstanding);
            for (ServerIdentity identity2 : outstanding) {
                this.executor.cancelTask(identity2);
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
    }
}

