/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.ManagedReferenceReleaseInterceptor;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.Interceptors;
import org.jboss.msc.value.InjectedValue;
import org.jboss.msc.value.Value;

public class AbstractComponentConfigurator {
    protected static InterceptorFactory weaved(final Collection<InterceptorFactory> interceptorFactories) {
        if (interceptorFactories == null) {
            return null;
        }
        return new InterceptorFactory(){

            public Interceptor create(InterceptorFactoryContext context) {
                Interceptor[] interceptors = new Interceptor[interceptorFactories.size()];
                Iterator factories = interceptorFactories.iterator();
                for (int i = 0; i < interceptors.length; ++i) {
                    interceptors[i] = ((InterceptorFactory)factories.next()).create(context);
                }
                return Interceptors.getWeavedInterceptor((Interceptor[])interceptors);
            }
        };
    }

    protected void mergeInjectionsForClass(Class<?> clazz, Class<?> actualClass, EEModuleClassDescription classDescription, EEModuleDescription moduleDescription, DeploymentReflectionIndex deploymentReflectionIndex, ComponentDescription description, ComponentConfiguration configuration, DeploymentPhaseContext context, Deque<InterceptorFactory> injectors, Object instanceKey, Deque<InterceptorFactory> uninjectors, boolean metadataComplete) throws DeploymentUnitProcessingException {
        HashMap<InjectionTarget, ResourceInjectionConfiguration> mergedInjections = new HashMap<InjectionTarget, ResourceInjectionConfiguration>();
        if (classDescription != null && !metadataComplete) {
            mergedInjections.putAll(classDescription.getInjectionConfigurations());
        }
        mergedInjections.putAll(moduleDescription.getResourceInjections(clazz.getName()));
        mergedInjections.putAll(description.getResourceInjections(clazz.getName()));
        for (ResourceInjectionConfiguration injectionConfiguration : mergedInjections.values()) {
            MethodInjectionTarget mt;
            Method method;
            if (!moduleDescription.isAppClient() && injectionConfiguration.getTarget().isStatic(context.getDeploymentUnit())) {
                EeLogger.SERVER_DEPLOYMENT_LOGGER.debugf("Injection for a member with static modifier is only acceptable on application clients, ignoring injection for target %s", injectionConfiguration.getTarget());
                continue;
            }
            if (injectionConfiguration.getTarget() instanceof MethodInjectionTarget && !this.isNotOverriden(clazz, method = (mt = (MethodInjectionTarget)injectionConfiguration.getTarget()).getMethod(deploymentReflectionIndex, clazz), actualClass, deploymentReflectionIndex)) continue;
            Object valueContextKey = new Object();
            InjectedValue managedReferenceFactoryValue = new InjectedValue();
            configuration.getStartDependencies().add(new ComponentDescription.InjectedConfigurator(injectionConfiguration, configuration, context, (InjectedValue<ManagedReferenceFactory>)managedReferenceFactoryValue));
            injectors.addFirst(injectionConfiguration.getTarget().createInjectionInterceptorFactory(instanceKey, valueContextKey, (Value<ManagedReferenceFactory>)managedReferenceFactoryValue, context.getDeploymentUnit(), injectionConfiguration.isOptional()));
            uninjectors.addLast((InterceptorFactory)new ImmediateInterceptorFactory((Interceptor)new ManagedReferenceReleaseInterceptor(valueContextKey)));
        }
    }

    protected boolean isNotOverriden(Class<?> clazz, Method method, Class<?> actualClass, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        return Modifier.isPrivate(method.getModifiers()) || ClassReflectionIndexUtil.findRequiredMethod((DeploymentReflectionIndex)deploymentReflectionIndex, actualClass, (Method)method).getDeclaringClass() == clazz;
    }
}

