/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.io.File;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.io.IOServices;
import org.wildfly.extension.undertow.AccessLogDefinition;
import org.wildfly.extension.undertow.AccessLogService;
import org.wildfly.extension.undertow.UndertowService;
import org.xnio.XnioWorker;

class AccessLogAdd
extends AbstractAddStepHandler {
    AccessLogAdd() {
        super(AccessLogDefinition.ATTRIBUTES);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
        PathAddress hostAddress = address.subAddress(0, address.size() - 1);
        PathAddress serverAddress = hostAddress.subAddress(0, hostAddress.size() - 1);
        String worker = AccessLogDefinition.WORKER.resolveModelAttribute(context, model).asString();
        String pattern = AccessLogDefinition.PATTERN.resolveModelAttribute(context, model).asString();
        String directory = AccessLogDefinition.DIRECTORY.resolveModelAttribute(context, model).asString();
        String filePrefix = AccessLogDefinition.PREFIX.resolveModelAttribute(context, model).asString();
        String fileSuffix = AccessLogDefinition.SUFFIX.resolveModelAttribute(context, model).asString();
        AccessLogService service = new AccessLogService(pattern, new File(directory), filePrefix, fileSuffix);
        String serverName = serverAddress.getLastElement().getValue();
        String hostName = hostAddress.getLastElement().getValue();
        ServiceName serviceName = UndertowService.accessLogServiceName(serverName, hostName);
        ServiceBuilder builder = context.getServiceTarget().addService(serviceName, (Service)service).addDependency(IOServices.WORKER.append(new String[]{worker}), XnioWorker.class, service.getWorker());
        builder.setInitialMode(ServiceController.Mode.ACTIVE).install();
    }
}

