/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aesh.edit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jboss.aesh.edit.EditMode;
import org.jboss.aesh.edit.KeyOperation;
import org.jboss.aesh.edit.KeyOperationManager;
import org.jboss.aesh.edit.Mode;
import org.jboss.aesh.edit.actions.Action;
import org.jboss.aesh.edit.actions.Operation;

public class EmacsEditMode
implements EditMode {
    private Action mode = Action.EDIT;
    private KeyOperationManager operationManager;
    private List<KeyOperation> currentOperations = new ArrayList<KeyOperation>();
    private int operationLevel = 0;

    public EmacsEditMode(KeyOperationManager operations) {
        this.operationManager = operations;
    }

    @Override
    public Operation parseInput(int[] in, String buffer) {
        int input = in[0];
        if (in.length > 1) {
            KeyOperation ko = this.operationManager.findOperation(in);
            if (ko != null) {
                this.currentOperations.clear();
                this.currentOperations.add(ko);
            }
        } else if (this.operationLevel > 0) {
            Iterator<KeyOperation> operationIterator = this.currentOperations.iterator();
            while (operationIterator.hasNext()) {
                if (input == operationIterator.next().getKeyValues()[this.operationLevel]) continue;
                operationIterator.remove();
            }
        } else {
            for (KeyOperation ko : this.operationManager.getOperations()) {
                if (input != ko.getFirstValue()) continue;
                this.currentOperations.add(ko);
            }
        }
        if (this.mode == Action.SEARCH) {
            if (this.currentOperations.size() == 1) {
                if (this.currentOperations.get(0).getOperation() == Operation.NEW_LINE) {
                    this.mode = Action.EDIT;
                    this.currentOperations.clear();
                    return Operation.SEARCH_END;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.SEARCH_PREV) {
                    this.currentOperations.clear();
                    return Operation.SEARCH_PREV_WORD;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.SEARCH_NEXT_WORD) {
                    this.currentOperations.clear();
                    return Operation.SEARCH_NEXT_WORD;
                }
                if (this.currentOperations.get(0).getOperation() == Operation.DELETE_PREV_CHAR) {
                    this.currentOperations.clear();
                    return Operation.SEARCH_DELETE;
                }
                this.currentOperations.clear();
                return Operation.NO_ACTION;
            }
            if (this.currentOperations.size() > 1) {
                this.mode = Action.EDIT;
                this.currentOperations.clear();
                return Operation.SEARCH_EXIT;
            }
            this.currentOperations.clear();
            return Operation.SEARCH_INPUT;
        }
        if (this.currentOperations.isEmpty()) {
            if (this.operationLevel > 0) {
                this.operationLevel = 0;
                this.currentOperations.clear();
                return Operation.NO_ACTION;
            }
            return Operation.EDIT;
        }
        if (this.currentOperations.size() == 1) {
            int level = this.operationLevel + 1;
            if (in.length > level) {
                level = in.length;
            }
            if (this.currentOperations.get(0).getKeyValues().length > level) {
                ++this.operationLevel;
                return Operation.NO_ACTION;
            }
            Operation currentOperation = this.currentOperations.get(0).getOperation();
            if (currentOperation == Operation.SEARCH_PREV || currentOperation == Operation.SEARCH_NEXT_WORD) {
                this.mode = Action.SEARCH;
            }
            this.operationLevel = 0;
            this.currentOperations.clear();
            if (currentOperation.equals((Object)Operation.EXIT)) {
                if (buffer.isEmpty()) {
                    return currentOperation;
                }
                return Operation.DELETE_NEXT_CHAR;
            }
            return currentOperation;
        }
        ++this.operationLevel;
        return Operation.NO_ACTION;
    }

    @Override
    public Action getCurrentAction() {
        return this.mode;
    }

    @Override
    public Mode getMode() {
        return Mode.EMACS;
    }
}

