/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Decoder;

public abstract class DesCbcDecoder
extends Decoder {
    protected abstract byte[] calculateChecksum(byte[] var1, int var2) throws NegotiationException;

    public int blockSize() {
        return 8;
    }

    public int keySize() {
        return 8;
    }

    public int confounderSize() {
        return 8;
    }

    public byte[] decrypt(byte[] cipher, byte[] key, int usage) throws NegotiationException {
        byte[] ivec = new byte[this.keySize()];
        return this.decrypt(cipher, key, ivec, usage);
    }

    public byte[] decrypt(byte[] cipher, byte[] key, byte[] ivec, int usage) throws NegotiationException {
        if (key.length > 8) {
            throw new NegotiationException("Invalid DES Key!");
        }
        byte[] data = new byte[cipher.length];
        DesCbcDecoder.cbc_encrypt(cipher, data, key, ivec, false);
        if (!this.isChecksumValid(data)) {
            throw new NegotiationException("Bad integrity check on AP_REQ");
        }
        return data;
    }

    protected boolean isChecksumValid(byte[] data) throws NegotiationException {
        byte[] cksum1 = this.checksumField(data);
        byte[] cksum2 = this.generateChecksum(data);
        return this.isChecksumEqual(cksum1, cksum2);
    }

    private boolean isChecksumEqual(byte[] cksum1, byte[] cksum2) {
        if (cksum1 == cksum2) {
            return true;
        }
        if (cksum1 == null && cksum2 != null || cksum1 != null && cksum2 == null) {
            return false;
        }
        if (cksum1.length != cksum2.length) {
            return false;
        }
        for (int i = 0; i < cksum1.length; ++i) {
            if (cksum1[i] == cksum2[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] checksumField(byte[] data) {
        byte[] result = new byte[this.checksumSize()];
        for (int i = 0; i < this.checksumSize(); ++i) {
            result[i] = data[this.startOfChecksum() + i];
        }
        return result;
    }

    private byte[] generateChecksum(byte[] data) throws NegotiationException {
        byte[] cksum1 = this.checksumField(data);
        this.resetChecksumField(data);
        byte[] cksum2 = this.calculateChecksum(data, data.length);
        this.copyChecksumField(data, cksum1);
        return cksum2;
    }

    private void resetChecksumField(byte[] data) {
        for (int i = this.startOfChecksum(); i < this.startOfChecksum() + this.checksumSize(); ++i) {
            data[i] = 0;
        }
    }

    private void copyChecksumField(byte[] data, byte[] cksum) {
        for (int i = 0; i < this.checksumSize(); ++i) {
            data[this.startOfChecksum() + i] = cksum[i];
        }
    }

    public static void cbc_encrypt(byte[] input, byte[] output, byte[] key, byte[] ivec, boolean encrypt) throws NegotiationException {
        Cipher cipher = null;
        try {
            cipher = Cipher.getInstance("DES/CBC/NoPadding");
        }
        catch (GeneralSecurityException e) {
            NegotiationException ne = new NegotiationException("JCE provider may not be installed. " + e.getMessage());
            ne.initCause(e);
            throw ne;
        }
        IvParameterSpec params = new IvParameterSpec(ivec);
        SecretKeySpec skSpec = new SecretKeySpec(key, "DES");
        try {
            SecretKeySpec sk = skSpec;
            if (encrypt) {
                cipher.init(1, (Key)sk, params);
            } else {
                cipher.init(2, (Key)sk, params);
            }
            byte[] result = cipher.doFinal(input);
            System.arraycopy(result, 0, output, 0, result.length);
        }
        catch (GeneralSecurityException e) {
            NegotiationException ne = new NegotiationException(e.getMessage());
            ne.initCause(e);
            throw ne;
        }
    }
}

