/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.conduits;

import io.undertow.UndertowLogger;
import io.undertow.UndertowOptions;
import io.undertow.server.OpenListener;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.IoUtils;
import org.xnio.Options;
import org.xnio.StreamConnection;
import org.xnio.XnioExecutor;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.conduits.AbstractStreamSourceConduit;
import org.xnio.conduits.StreamSourceConduit;

public final class ReadTimeoutStreamSourceConduit
extends AbstractStreamSourceConduit<StreamSourceConduit> {
    private XnioExecutor.Key handle;
    private final StreamConnection connection;
    private volatile long expireTime = -1L;
    private final OpenListener openListener;
    private static final int FUZZ_FACTOR = 50;
    private final Runnable timeoutCommand = new Runnable(){

        @Override
        public void run() {
            ReadTimeoutStreamSourceConduit.this.handle = null;
            if (ReadTimeoutStreamSourceConduit.this.expireTime == -1L) {
                return;
            }
            long current = System.currentTimeMillis();
            if (current < ReadTimeoutStreamSourceConduit.this.expireTime) {
                ReadTimeoutStreamSourceConduit.this.handle = ReadTimeoutStreamSourceConduit.this.connection.getIoThread().executeAfter(ReadTimeoutStreamSourceConduit.this.timeoutCommand, ReadTimeoutStreamSourceConduit.this.expireTime - current + 50L, TimeUnit.MILLISECONDS);
                return;
            }
            UndertowLogger.REQUEST_LOGGER.tracef("Timing out channel %s due to inactivity", ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel());
            IoUtils.safeClose((Closeable)ReadTimeoutStreamSourceConduit.this.connection);
            if (ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel().isReadResumed()) {
                ChannelListeners.invokeChannelListener((Channel)ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel(), (ChannelListener)ReadTimeoutStreamSourceConduit.this.connection.getSourceChannel().getReadListener());
            }
            if (ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel().isWriteResumed()) {
                ChannelListeners.invokeChannelListener((Channel)ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel(), (ChannelListener)ReadTimeoutStreamSourceConduit.this.connection.getSinkChannel().getWriteListener());
            }
        }
    };

    public ReadTimeoutStreamSourceConduit(StreamSourceConduit delegate, StreamConnection connection, OpenListener openListener) {
        super(delegate);
        this.connection = connection;
        this.openListener = openListener;
    }

    private void handleReadTimeout(long ret) throws IOException {
        if (!this.connection.isOpen()) {
            if (this.handle != null) {
                this.handle.remove();
                this.handle = null;
            }
            return;
        }
        if (ret == -1L) {
            if (this.handle != null) {
                this.handle.remove();
                this.handle = null;
            }
            return;
        }
        if (ret == 0L && this.handle != null) {
            return;
        }
        Integer timeout = this.getTimeout();
        if (timeout == null || timeout <= 0) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        long expireTimeVar = this.expireTime;
        if (expireTimeVar != -1L && currentTime > expireTimeVar) {
            IoUtils.safeClose((Closeable)this.connection);
            throw new ClosedChannelException();
        }
        this.expireTime = currentTime + (long)timeout.intValue();
        XnioExecutor.Key key = this.handle;
        if (key == null) {
            this.handle = this.connection.getIoThread().executeAfter(this.timeoutCommand, (long)timeout.intValue(), TimeUnit.MILLISECONDS);
        }
    }

    public long transferTo(long position, long count, FileChannel target) throws IOException {
        long ret = super.transferTo(position, count, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    public long transferTo(long count, ByteBuffer throughBuffer, StreamSinkChannel target) throws IOException {
        long ret = super.transferTo(count, throughBuffer, target);
        this.handleReadTimeout(ret);
        return ret;
    }

    public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
        long ret = super.read(dsts, offset, length);
        this.handleReadTimeout(ret);
        return ret;
    }

    public int read(ByteBuffer dst) throws IOException {
        int ret = super.read(dst);
        this.handleReadTimeout(ret);
        return ret;
    }

    public void awaitReadable() throws IOException {
        Integer timeout = this.getTimeout();
        if (timeout != null && timeout > 0) {
            super.awaitReadable((long)(timeout + 50), TimeUnit.MILLISECONDS);
        } else {
            super.awaitReadable();
        }
    }

    public void awaitReadable(long time, TimeUnit timeUnit) throws IOException {
        Integer timeout = this.getTimeout();
        if (timeout != null && timeout > 0) {
            long millis = timeUnit.toMillis(time);
            super.awaitReadable(Math.min(millis, (long)(timeout + 50)), TimeUnit.MILLISECONDS);
        } else {
            super.awaitReadable(time, timeUnit);
        }
    }

    private Integer getTimeout() throws IOException {
        Integer timeout = (Integer)this.connection.getSourceChannel().getOption(Options.READ_TIMEOUT);
        Integer idleTimeout = (Integer)this.openListener.getUndertowOptions().get(UndertowOptions.IDLE_TIMEOUT);
        if ((timeout == null || timeout <= 0) && idleTimeout != null) {
            timeout = idleTimeout;
        } else if (timeout != null && idleTimeout != null && idleTimeout > 0) {
            timeout = Math.min(timeout, idleTimeout);
        }
        return timeout;
    }

    public void terminateReads() throws IOException {
        super.terminateReads();
        if (this.handle != null) {
            this.handle.remove();
            this.handle = null;
        }
    }
}

