/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.util.HashSet;
import java.util.Set;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.extension.ExtensionRegistry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.transform.RuntimeIgnoreTransformation;
import org.jboss.as.host.controller.IgnoredNonAffectedServerGroupsUtil;
import org.jboss.as.host.controller.mgmt.HostInfo;

public class DomainControllerRuntimeIgnoreTransformationEntry
implements RuntimeIgnoreTransformation {
    private final HostInfo hostInfo;
    private final IgnoredNonAffectedServerGroupsUtil util;
    private volatile Set<PathElement> knownRootAddresses;

    private DomainControllerRuntimeIgnoreTransformationEntry(HostInfo hostInfo, ExtensionRegistry extensionRegistry) {
        this.hostInfo = hostInfo;
        this.util = IgnoredNonAffectedServerGroupsUtil.create(extensionRegistry);
    }

    static DomainControllerRuntimeIgnoreTransformationEntry create(HostInfo hostInfo, ExtensionRegistry extensionRegistry) {
        return new DomainControllerRuntimeIgnoreTransformationEntry(hostInfo, extensionRegistry);
    }

    void setKnownRootAddresses(Set<PathElement> knownRootAddresses) {
        this.knownRootAddresses = knownRootAddresses;
    }

    boolean isIgnoreUnaffactedConfig() {
        return this.hostInfo.isIgnoreUnaffectedConfig();
    }

    public boolean ignoreResource(Resource domainResource, PathAddress address) {
        if (address.size() != 1) {
            return false;
        }
        if (this.hostInfo.isIgnoreUnaffectedConfig()) {
            if (this.knownRootAddresses != null && address.size() >= 0 && this.knownRootAddresses.contains(address.getElement(0))) {
                return false;
            }
            return this.util.ignoreResource(domainResource, this.hostInfo.getServerConfigInfos(), address);
        }
        return false;
    }

    void updateSlaveServerConfig(IgnoredNonAffectedServerGroupsUtil.ServerConfigInfo serverInfo) {
        if (this.hostInfo.isIgnoreUnaffectedConfig()) {
            this.hostInfo.updateSlaveServerConfigInfo(serverInfo);
        }
    }

    Set<PathElement> getUnknownExtensionsForProfile(Resource domainResource, PathElement profileElement) {
        Set<PathElement> allExtensions = this.util.getAllExtensionsForProfile(domainResource, profileElement);
        HashSet<PathElement> unknownExtensions = new HashSet<PathElement>();
        for (PathElement extensionElement : allExtensions) {
            if (this.knownRootAddresses.contains(extensionElement)) continue;
            unknownExtensions.add(extensionElement);
        }
        return unknownExtensions;
    }
}

