/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class MethodIdentifier
implements Serializable {
    private static final long serialVersionUID = -4303462176794600579L;
    private final String returnType;
    private final String name;
    private final String[] parameterTypes;
    private final int hashCode;
    private static final String[] NO_STRINGS = new String[0];
    private static final Map<String, Class<?>> PRIMITIVES;
    public static final MethodIdentifier EQUALS;
    public static final MethodIdentifier HASH_CODE;
    public static final MethodIdentifier TO_STRING;
    public static final MethodIdentifier FINALIZE;

    private MethodIdentifier(String returnType, String name, String ... parameterTypes) {
        if (returnType == null) {
            throw new IllegalArgumentException("returnType is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (parameterTypes == null) {
            throw new IllegalArgumentException("parameterTypes is null");
        }
        this.returnType = returnType;
        this.name = name;
        this.parameterTypes = parameterTypes == null || parameterTypes.length == 0 ? NO_STRINGS : (String[])parameterTypes.clone();
        this.hashCode = MethodIdentifier.calculateHash(returnType, name, parameterTypes);
    }

    private MethodIdentifier(Method method) {
        this.returnType = method.getReturnType().getName();
        String name = this.name = method.getName();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        String[] parameterTypes = methodParameterTypes.length == 0 ? NO_STRINGS : MethodIdentifier.namesOf(methodParameterTypes);
        this.hashCode = MethodIdentifier.calculateHash(this.returnType, name, parameterTypes);
        this.parameterTypes = parameterTypes;
    }

    private static String[] namesOf(Class<?>[] types) {
        String[] strings = new String[types.length];
        int typesLength = types.length;
        for (int i = 0; i < typesLength; ++i) {
            strings[i] = types[i].getName();
        }
        return strings;
    }

    private static Class<?>[] typesOf(String[] names, ClassLoader classLoader) throws ClassNotFoundException {
        Class[] types = new Class[names.length];
        int namesLength = names.length;
        for (int i = 0; i < namesLength; ++i) {
            Class<?> prim = PRIMITIVES.get(names[i]);
            types[i] = prim == null ? Class.forName(names[i], false, classLoader) : prim;
        }
        return types;
    }

    private static int calculateHash(String returnType, String name, String[] parameterTypes) {
        return name.hashCode() * 7 + (returnType.hashCode() * 7 + Arrays.hashCode(parameterTypes));
    }

    public String getName() {
        return this.name;
    }

    public String[] getParameterTypes() {
        String[] parameterTypes = this.parameterTypes;
        return parameterTypes == NO_STRINGS ? parameterTypes : (String[])parameterTypes.clone();
    }

    public String getReturnType() {
        return this.returnType;
    }

    public boolean equals(Object other) {
        return other instanceof MethodIdentifier && this.equals((MethodIdentifier)other);
    }

    public boolean equals(MethodIdentifier other) {
        return this == other || other != null && this.hashCode == other.hashCode && this.returnType.equals(other.returnType) && this.name.equals(other.name) && Arrays.equals(this.parameterTypes, other.parameterTypes);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Method getPublicMethod(Class<?> clazz) throws NoSuchMethodException, ClassNotFoundException {
        return clazz.getMethod(this.name, MethodIdentifier.typesOf(this.parameterTypes, clazz.getClassLoader()));
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Method ").append(this.name).append('(');
        for (String type : this.parameterTypes) {
            b.append(type);
        }
        return b.append(')').toString();
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
    }

    public static MethodIdentifier getIdentifierForMethod(Method method) {
        return new MethodIdentifier(method);
    }

    public static MethodIdentifier getIdentifier(Class<?> returnType, String name, Class<?> ... parameterTypes) {
        return new MethodIdentifier(returnType.getName(), name, MethodIdentifier.namesOf(parameterTypes));
    }

    public static MethodIdentifier getIdentifier(String returnType, String name, String ... parameterTypes) {
        return new MethodIdentifier(returnType, name, parameterTypes);
    }

    static {
        HashMap primitives = new HashMap();
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("void", Void.TYPE);
        PRIMITIVES = primitives;
        EQUALS = MethodIdentifier.getIdentifier(Boolean.TYPE, "equals", Object.class);
        HASH_CODE = MethodIdentifier.getIdentifier(Integer.TYPE, "hashCode", new Class[0]);
        TO_STRING = MethodIdentifier.getIdentifier(String.class, "toString", new Class[0]);
        FINALIZE = MethodIdentifier.getIdentifier(Void.TYPE, "finalize", new Class[0]);
    }
}

