/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.compiler;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.apache.jasper.JasperException;
import org.apache.jasper.JasperLogger;
import org.apache.jasper.JasperMessages;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.BeanRepository;
import org.apache.jasper.compiler.Collector;
import org.apache.jasper.compiler.ELFunctionMapper;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.Generator;
import org.apache.jasper.compiler.JspConfig;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Node;
import org.apache.jasper.compiler.PageInfo;
import org.apache.jasper.compiler.ParserController;
import org.apache.jasper.compiler.ScriptingVariabler;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SmapUtil;
import org.apache.jasper.compiler.TagFileProcessor;
import org.apache.jasper.compiler.TagPluginManager;
import org.apache.jasper.compiler.TextOptimizer;
import org.apache.jasper.compiler.Validator;
import org.apache.jasper.servlet.JspServletWrapper;

public abstract class Compiler {
    protected JspCompilationContext ctxt;
    protected ErrorDispatcher errDispatcher;
    protected PageInfo pageInfo;
    protected JspServletWrapper jsw;
    protected TagFileProcessor tfp;
    protected Options options;
    protected Node.Nodes pageNodes;

    public void init(JspCompilationContext ctxt, JspServletWrapper jsw) {
        this.jsw = jsw;
        this.ctxt = ctxt;
        this.options = ctxt.getOptions();
    }

    public Node.Nodes getPageNodes() {
        return this.pageNodes;
    }

    protected String[] generateJava() throws Exception {
        String[] smapStr = null;
        long t4 = 0L;
        long t3 = 0L;
        long t2 = 0L;
        long t1 = 0L;
        if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
            t1 = System.currentTimeMillis();
        }
        this.pageInfo = new PageInfo(new BeanRepository(this.ctxt.getClassLoader(), this.errDispatcher), this.ctxt.getJspFile(), this.ctxt.isTagFile());
        JspConfig jspConfig = this.options.getJspConfig();
        JspConfig.JspProperty jspProperty = jspConfig.findJspProperty(this.ctxt.getJspFile());
        if (jspProperty.isELIgnored() != null) {
            this.pageInfo.setELIgnored(JspUtil.booleanValue(jspProperty.isELIgnored()));
        }
        if (jspProperty.isScriptingInvalid() != null) {
            this.pageInfo.setScriptingInvalid(JspUtil.booleanValue(jspProperty.isScriptingInvalid()));
        }
        if (jspProperty.getIncludePrelude() != null) {
            this.pageInfo.setIncludePrelude(jspProperty.getIncludePrelude());
        }
        if (jspProperty.getIncludeCoda() != null) {
            this.pageInfo.setIncludeCoda(jspProperty.getIncludeCoda());
        }
        if (jspProperty.isDeferedSyntaxAllowedAsLiteral() != null) {
            this.pageInfo.setDeferredSyntaxAllowedAsLiteral(JspUtil.booleanValue(jspProperty.isDeferedSyntaxAllowedAsLiteral()));
        }
        if (jspProperty.isTrimDirectiveWhitespaces() != null) {
            this.pageInfo.setTrimDirectiveWhitespaces(JspUtil.booleanValue(jspProperty.isTrimDirectiveWhitespaces()));
        }
        if (jspProperty.getBuffer() != null && this.pageInfo.getBufferValue() == null) {
            this.pageInfo.setBufferValue(jspProperty.getBuffer(), this.errDispatcher);
        }
        if (jspProperty.isErrorOnUndeclaredNamespace() != null) {
            this.pageInfo.setErrorOnUndeclaredNamespace(JspUtil.booleanValue(jspProperty.isErrorOnUndeclaredNamespace()));
        }
        if (this.ctxt.isTagFile()) {
            try {
                double libraryVersion = Double.parseDouble(this.ctxt.getTagInfo().getTagLibrary().getRequiredVersion());
                if (libraryVersion < 2.0) {
                    this.pageInfo.setIsELIgnored("true", null, this.errDispatcher, true);
                }
                if (libraryVersion < 2.1) {
                    this.pageInfo.setDeferredSyntaxAllowedAsLiteral("true", null, this.errDispatcher, true);
                }
            }
            catch (NumberFormatException ex) {
                this.errDispatcher.jspError(JasperMessages.MESSAGES.malformedLibraryVersionNumber(), ex);
            }
        }
        this.ctxt.checkOutputDir();
        String javaFileName = this.ctxt.getServletJavaFileName();
        ServletWriter writer = null;
        try {
            ParserController parserCtl = new ParserController(this.ctxt, this);
            Node.Nodes directives = parserCtl.parseDirectives(this.ctxt.getJspFile());
            Validator.validateDirectives(this, directives);
            this.pageNodes = parserCtl.parse(this.ctxt.getJspFile());
            if (jspProperty.getDefaultContentType() != null && this.pageInfo.getContentType() == null) {
                this.pageInfo.setContentType(jspProperty.getDefaultContentType());
            }
            if (this.ctxt.isPrototypeMode()) {
                writer = this.setupContextWriter(javaFileName);
                Generator.generate(writer, this, this.pageNodes);
                writer.close();
                writer = null;
                String[] stringArray = null;
                return stringArray;
            }
            Validator.validateExDirectives(this, this.pageNodes);
            if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            Collector.collect(this, this.pageNodes);
            this.tfp = new TagFileProcessor();
            this.tfp.loadTagFiles(this, this.pageNodes);
            if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                t3 = System.currentTimeMillis();
            }
            ScriptingVariabler.set(this.pageNodes, this.errDispatcher);
            TagPluginManager tagPluginManager = this.options.getTagPluginManager();
            tagPluginManager.apply(this.pageNodes, this.errDispatcher, this.pageInfo);
            TextOptimizer.concatenate(this, this.pageNodes);
            ELFunctionMapper.map(this.pageNodes);
            writer = this.setupContextWriter(javaFileName);
            Generator.generate(writer, this, this.pageNodes);
            writer.close();
            writer = null;
            this.ctxt.setWriter(null);
            if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                t4 = System.currentTimeMillis();
                JasperLogger.COMPILER_LOGGER.debug("Generated " + javaFileName + " total=" + (t4 - t1) + " generate=" + (t4 - t3) + " validate=" + (t2 - t1));
            }
        }
        catch (Exception e) {
            if (writer != null) {
                try {
                    writer.close();
                    writer = null;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
            new File(javaFileName).delete();
            throw e;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e2) {}
            }
        }
        if (!this.options.isSmapSuppressed()) {
            smapStr = SmapUtil.generateSmap(this.ctxt, this.pageNodes);
        }
        this.tfp.removeProtoTypeFiles(this.ctxt.getClassFileName());
        return smapStr;
    }

    private ServletWriter setupContextWriter(String javaFileName) throws FileNotFoundException, JasperException {
        String javaEncoding = this.ctxt.getOptions().getJavaEncoding();
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(javaFileName), javaEncoding);
        }
        catch (UnsupportedEncodingException ex) {
            this.errDispatcher.jspError(JasperMessages.MESSAGES.needAlternateEncoding(javaEncoding));
        }
        ServletWriter writer = new ServletWriter(new PrintWriter(osw));
        this.ctxt.setWriter(writer);
        return writer;
    }

    protected abstract void generateClass(String[] var1) throws FileNotFoundException, JasperException, Exception;

    public void compile() throws FileNotFoundException, JasperException, Exception {
        this.compile(true);
    }

    public void compile(boolean compileClass) throws FileNotFoundException, JasperException, Exception {
        this.compile(compileClass, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(boolean compileClass, boolean jspcMode) throws FileNotFoundException, JasperException, Exception {
        if (this.errDispatcher == null) {
            this.errDispatcher = new ErrorDispatcher(jspcMode);
        }
        try {
            String[] smap = this.generateJava();
            if (compileClass) {
                File targetFile;
                this.generateClass(smap);
                String targetFileName = this.ctxt.getClassFileName();
                if (targetFileName != null && (targetFile = new File(targetFileName)).exists() && this.jsw != null) {
                    this.jsw.setServletClassLastModifiedTime(targetFile.lastModified());
                }
            }
        }
        finally {
            if (this.tfp != null) {
                this.tfp.removeProtoTypeFiles(null);
            }
            this.tfp = null;
            this.errDispatcher = null;
            this.pageInfo = null;
            if (!this.options.getDevelopment()) {
                this.pageNodes = null;
            }
            if (this.ctxt.getWriter() != null) {
                this.ctxt.getWriter().close();
                this.ctxt.setWriter(null);
            }
        }
    }

    public boolean isOutDated() {
        return this.isOutDated(true);
    }

    public boolean isOutDated(boolean checkClass) {
        String jsp = this.ctxt.getJspFile();
        if (this.jsw != null && this.ctxt.getOptions().getModificationTestInterval() > 0) {
            if (this.jsw.getLastModificationTest() + (long)(this.ctxt.getOptions().getModificationTestInterval() * 1000) > System.currentTimeMillis()) {
                return false;
            }
            this.jsw.setLastModificationTest(System.currentTimeMillis());
        }
        long jspRealLastModified = 0L;
        try {
            URL jspUrl = this.ctxt.getResource(jsp);
            if (jspUrl == null) {
                this.ctxt.incrementRemoved();
                return false;
            }
            URLConnection uc = jspUrl.openConnection();
            jspRealLastModified = uc instanceof JarURLConnection ? ((JarURLConnection)uc).getJarEntry().getTime() : uc.getLastModified();
            uc.getInputStream().close();
        }
        catch (Exception e) {
            return true;
        }
        long targetLastModified = 0L;
        File targetFile = checkClass ? new File(this.ctxt.getClassFileName()) : new File(this.ctxt.getServletJavaFileName());
        if (!targetFile.exists()) {
            return true;
        }
        targetLastModified = targetFile.lastModified();
        if (checkClass && this.jsw != null) {
            this.jsw.setServletClassLastModifiedTime(targetLastModified);
        }
        if (targetLastModified < jspRealLastModified) {
            if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                JasperLogger.COMPILER_LOGGER.debug("Compiler: outdated: " + targetFile + " " + targetLastModified);
            }
            return true;
        }
        if (this.jsw == null) {
            return false;
        }
        List depends = this.jsw.getDependants();
        if (depends == null) {
            return false;
        }
        for (String include : depends) {
            try {
                URL includeUrl = this.ctxt.getResource(include);
                if (includeUrl == null) {
                    return true;
                }
                URLConnection iuc = includeUrl.openConnection();
                long includeLastModified = 0L;
                includeLastModified = iuc instanceof JarURLConnection ? ((JarURLConnection)iuc).getJarEntry().getTime() : iuc.getLastModified();
                iuc.getInputStream().close();
                if (includeLastModified <= targetLastModified) continue;
                return true;
            }
            catch (Exception e) {
                return true;
            }
        }
        return false;
    }

    public ErrorDispatcher getErrorDispatcher() {
        return this.errDispatcher;
    }

    public PageInfo getPageInfo() {
        return this.pageInfo;
    }

    public JspCompilationContext getCompilationContext() {
        return this.ctxt;
    }

    public void removeGeneratedFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                    JasperLogger.COMPILER_LOGGER.debug("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            String javaFileName = this.ctxt.getServletJavaFileName();
            if (javaFileName != null) {
                File javaFile = new File(javaFileName);
                if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                    JasperLogger.COMPILER_LOGGER.debug("Deleting " + javaFile);
                }
                javaFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeGeneratedClassFiles() {
        try {
            String classFileName = this.ctxt.getClassFileName();
            if (classFileName != null) {
                File classFile = new File(classFileName);
                if (JasperLogger.COMPILER_LOGGER.isDebugEnabled()) {
                    JasperLogger.COMPILER_LOGGER.debug("Deleting " + classFile);
                }
                classFile.delete();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

