package org.jboss.as.webservices.logging;

import java.util.Locale;
import org.jboss.vfs.VirtualFile;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import java.lang.IllegalStateException;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import org.jboss.as.server.deployment.module.ResourceRoot;
import java.lang.RuntimeException;
import java.lang.NullPointerException;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.logging.BasicLogger;
import org.jboss.wsf.spi.WSFException;
import org.jboss.msc.service.StartException;
import org.jboss.as.webservices.config.DisabledOperationException;
import java.lang.IllegalArgumentException;
import javax.annotation.Generated;
import javax.xml.ws.WebServiceException;
import org.jboss.as.controller.OperationFailedException;
import java.lang.SecurityException;
import java.lang.reflect.Method;
import java.io.IOException;
import java.lang.Exception;
import org.jboss.msc.service.ServiceName;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.FATAL;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2018-02-15T15:47:59+0000")
public class WSLogger_$logger extends DelegatingBasicLogger implements WSLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WSLogger_$logger.class.getName();
    public WSLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void cannotLoadDeploymentAspectsDefinitionFile(final String resourcePath) {
        super.log.logf(FQCN, WARN, null, cannotLoadDeploymentAspectsDefinitionFile$str(), resourcePath);
    }
    private static final String cannotLoadDeploymentAspectsDefinitionFile = "WFLYWS0001: Cannot load WS deployment aspects from %s";
    protected String cannotLoadDeploymentAspectsDefinitionFile$str() {
        return cannotLoadDeploymentAspectsDefinitionFile;
    }
    @Override
    public final RuntimeException cannotLoadDeploymentAspectsDefinitionFile(final Throwable cause, final String resourcePath) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotLoadDeploymentAspectsDefinitionFile$str(), resourcePath), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void activatingWebservicesExtension() {
        super.log.logf(FQCN, INFO, null, activatingWebservicesExtension$str());
    }
    private static final String activatingWebservicesExtension = "WFLYWS0002: Activating WebServices Extension";
    protected String activatingWebservicesExtension$str() {
        return activatingWebservicesExtension;
    }
    @Override
    public final void starting(final Object object) {
        super.log.logf(FQCN, INFO, null, starting$str(), object);
    }
    private static final String starting = "WFLYWS0003: Starting %s";
    protected String starting$str() {
        return starting;
    }
    @Override
    public final void stopping(final Object object) {
        super.log.logf(FQCN, INFO, null, stopping$str(), object);
    }
    private static final String stopping = "WFLYWS0004: Stopping %s";
    protected String stopping$str() {
        return stopping;
    }
    @Override
    public final void configServiceCreationFailed() {
        super.log.logf(FQCN, FATAL, null, configServiceCreationFailed$str());
    }
    private static final String configServiceCreationFailed = "WFLYWS0005: Error while creating configuration service";
    protected String configServiceCreationFailed$str() {
        return configServiceCreationFailed;
    }
    @Override
    public final void configServiceDestroyFailed() {
        super.log.logf(FQCN, ERROR, null, configServiceDestroyFailed$str());
    }
    private static final String configServiceDestroyFailed = "WFLYWS0006: Error while destroying configuration service";
    protected String configServiceDestroyFailed$str() {
        return configServiceDestroyFailed;
    }
    @Override
    public final void cannotReadWsdl(final String wsdlLocation) {
        super.log.logf(FQCN, WARN, null, cannotReadWsdl$str(), wsdlLocation);
    }
    private static final String cannotReadWsdl = "WFLYWS0007: Could not read WSDL from: %s";
    protected String cannotReadWsdl$str() {
        return cannotReadWsdl;
    }
    @Override
    public final void mutuallyExclusiveAnnotations(final String className) {
        super.log.logf(FQCN, WARN, null, mutuallyExclusiveAnnotations$str(), className);
    }
    private static final String mutuallyExclusiveAnnotations = "WFLYWS0008: [JAXWS 2.2 spec, section 7.7] The @WebService and @WebServiceProvider annotations are mutually exclusive - %s won't be considered as a webservice endpoint, since it doesn't meet that requirement";
    protected String mutuallyExclusiveAnnotations$str() {
        return mutuallyExclusiveAnnotations;
    }
    @Override
    public final void finalEndpointClassDetected(final String className) {
        super.log.logf(FQCN, WARN, null, finalEndpointClassDetected$str(), className);
    }
    private static final String finalEndpointClassDetected = "WFLYWS0009: WebService endpoint class cannot be final - %s won't be considered as a webservice endpoint";
    protected String finalEndpointClassDetected$str() {
        return finalEndpointClassDetected;
    }
    @Override
    public final void ignoringPortComponentRef(final Object o) {
        super.log.logf(FQCN, WARN, null, ignoringPortComponentRef$str(), o);
    }
    private static final String ignoringPortComponentRef = "WFLYWS0010: Ignoring <port-component-ref> without <service-endpoint-interface> and <port-qname>: %s";
    protected String ignoringPortComponentRef$str() {
        return ignoringPortComponentRef;
    }
    @Override
    public final void cannotRegisterRecordProcessor() {
        super.log.logf(FQCN, ERROR, null, cannotRegisterRecordProcessor$str());
    }
    private static final String cannotRegisterRecordProcessor = "WFLYWS0011: Cannot register record processor in JMX server";
    protected String cannotRegisterRecordProcessor$str() {
        return cannotRegisterRecordProcessor;
    }
    @Override
    public final void cannotUnregisterRecordProcessor() {
        super.log.logf(FQCN, ERROR, null, cannotUnregisterRecordProcessor$str());
    }
    private static final String cannotUnregisterRecordProcessor = "WFLYWS0012: Cannot unregister record processor from JMX server";
    protected String cannotUnregisterRecordProcessor$str() {
        return cannotUnregisterRecordProcessor;
    }
    @Override
    public final void mBeanServerNotAvailable(final Object bean) {
        super.log.logf(FQCN, INFO, null, mBeanServerNotAvailable$str(), bean);
    }
    private static final String mBeanServerNotAvailable = "WFLYWS0013: MBeanServer not available, skipping registration/unregistration of %s";
    protected String mBeanServerNotAvailable$str() {
        return mBeanServerNotAvailable;
    }
    @Override
    public final void multipleEndpointsWithDifferentDeclaredSecurityRoles() {
        super.log.logf(FQCN, WARN, null, multipleEndpointsWithDifferentDeclaredSecurityRoles$str());
    }
    private static final String multipleEndpointsWithDifferentDeclaredSecurityRoles = "WFLYWS0014: Multiple EJB3 endpoints in the same deployment with different declared security roles; be aware this might be a security risk if you're not controlling allowed roles (@RolesAllowed) on each ws endpoint method.";
    protected String multipleEndpointsWithDifferentDeclaredSecurityRoles$str() {
        return multipleEndpointsWithDifferentDeclaredSecurityRoles;
    }
    @Override
    public final void cannotRegisterEndpoint(final Object endpoint) {
        super.log.logf(FQCN, ERROR, null, cannotRegisterEndpoint$str(), endpoint);
    }
    private static final String cannotRegisterEndpoint = "WFLYWS0015: Cannot register endpoint: %s in JMX server";
    protected String cannotRegisterEndpoint$str() {
        return cannotRegisterEndpoint;
    }
    @Override
    public final void cannotUnregisterEndpoint(final Object endpoint) {
        super.log.logf(FQCN, ERROR, null, cannotUnregisterEndpoint$str(), endpoint);
    }
    private static final String cannotUnregisterEndpoint = "WFLYWS0016: Cannot unregister endpoint: %s from JMX server";
    protected String cannotUnregisterEndpoint$str() {
        return cannotUnregisterEndpoint;
    }
    @Override
    public final void invalidHandlerChainFile(final String fileName) {
        super.log.logf(FQCN, WARN, null, invalidHandlerChainFile$str(), fileName);
    }
    private static final String invalidHandlerChainFile = "WFLYWS0017: Invalid handler chain file: %s";
    protected String invalidHandlerChainFile$str() {
        return invalidHandlerChainFile;
    }
    @Override
    public final void webMethodMustNotBeStaticOrFinal(final Method staticWebMethod) {
        super.log.logf(FQCN, ERROR, null, webMethodMustNotBeStaticOrFinal$str(), staticWebMethod);
    }
    private static final String webMethodMustNotBeStaticOrFinal = "WFLYWS0018: Web service method %s must not be static or final. See section 5.3.2.4.2 of \"Web Services for Java EE, Version 1.4\".";
    protected String webMethodMustNotBeStaticOrFinal$str() {
        return webMethodMustNotBeStaticOrFinal;
    }
    @Override
    public final void webMethodMustBePublic(final Method staticWebMethod) {
        super.log.logf(FQCN, ERROR, null, webMethodMustBePublic$str(), staticWebMethod);
    }
    private static final String webMethodMustBePublic = "WFLYWS0019: Web service method %s must be public. See section 5.3.2.4.2 of \"Web Services for Java EE, Version 1.4\".";
    protected String webMethodMustBePublic$str() {
        return webMethodMustBePublic;
    }
    @Override
    public final void webServiceMethodNotFound(final Class<?> endpointClass, final Method potentialWebMethod) {
        super.log.logf(FQCN, ERROR, null, webServiceMethodNotFound$str(), endpointClass, potentialWebMethod);
    }
    private static final String webServiceMethodNotFound = "WFLYWS0020: Web service implementation class %s does not contain method %s";
    protected String webServiceMethodNotFound$str() {
        return webServiceMethodNotFound;
    }
    @Override
    public final void accessibleWebServiceMethodNotFound(final Class<?> endpointClass, final Method potentialWebMethod, final SecurityException e) {
        super.log.logf(FQCN, ERROR, e, accessibleWebServiceMethodNotFound$str(), endpointClass, potentialWebMethod);
    }
    private static final String accessibleWebServiceMethodNotFound = "WFLYWS0021: Web service implementation class %s does not contain an accessible method %s";
    protected String accessibleWebServiceMethodNotFound$str() {
        return accessibleWebServiceMethodNotFound;
    }
    @Override
    public final void finalizeMethodNotAllowed(final Class<?> seiClass) {
        super.log.logf(FQCN, ERROR, null, finalizeMethodNotAllowed$str(), seiClass);
    }
    private static final String finalizeMethodNotAllowed = "WFLYWS0022: Web service implementation class %s may not declare a finalize() method. See section 5.3.2.4.2 of \"Web Services for Java EE, Version 1.4\".";
    protected String finalizeMethodNotAllowed$str() {
        return finalizeMethodNotAllowed;
    }
    private static final String nullEndpointName = "WFLYWS0023: Null endpoint name";
    protected String nullEndpointName$str() {
        return nullEndpointName;
    }
    @Override
    public final NullPointerException nullEndpointName() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullEndpointName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String nullEndpointClass = "WFLYWS0024: Null endpoint class";
    protected String nullEndpointClass$str() {
        return nullEndpointClass;
    }
    @Override
    public final NullPointerException nullEndpointClass() {
        final NullPointerException result = new NullPointerException(String.format(getLoggingLocale(), nullEndpointClass$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String classLoaderResolutionFailed = "WFLYWS0025: Cannot resolve module or classloader for deployment %s";
    protected String classLoaderResolutionFailed$str() {
        return classLoaderResolutionFailed;
    }
    @Override
    public final IllegalStateException classLoaderResolutionFailed(final Object o) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), classLoaderResolutionFailed$str(), o));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingHandlerChainConfigFile = "WFLYWS0026: Handler chain config file %s not found in %s";
    protected String missingHandlerChainConfigFile$str() {
        return missingHandlerChainConfigFile;
    }
    @Override
    public final WebServiceException missingHandlerChainConfigFile(final String filePath, final ResourceRoot resourceRoot) {
        final WebServiceException result = new WebServiceException(String.format(getLoggingLocale(), missingHandlerChainConfigFile$str(), filePath, resourceRoot));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedElement = "WFLYWS0027: Unexpected element: %s";
    protected String unexpectedElement$str() {
        return unexpectedElement;
    }
    @Override
    public final IllegalStateException unexpectedElement(final String elementName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedElement$str(), elementName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEndTag = "WFLYWS0028: Unexpected end tag: %s";
    protected String unexpectedEndTag$str() {
        return unexpectedEndTag;
    }
    @Override
    public final IllegalStateException unexpectedEndTag(final String tagName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedEndTag$str(), tagName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unexpectedEndOfDocument = "WFLYWS0029: Reached end of xml document unexpectedly";
    protected String unexpectedEndOfDocument$str() {
        return unexpectedEndOfDocument;
    }
    @Override
    public final IllegalStateException unexpectedEndOfDocument() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), unexpectedEndOfDocument$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingDeploymentAspectClassAttribute = "WFLYWS0030: Could not find class attribute for deployment aspect";
    protected String missingDeploymentAspectClassAttribute$str() {
        return missingDeploymentAspectClassAttribute;
    }
    @Override
    public final IllegalStateException missingDeploymentAspectClassAttribute() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingDeploymentAspectClassAttribute$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateDeploymentAspect = "WFLYWS0031: Could not create a deployment aspect of class: %s";
    protected String cannotInstantiateDeploymentAspect$str() {
        return cannotInstantiateDeploymentAspect;
    }
    @Override
    public final IllegalStateException cannotInstantiateDeploymentAspect(final Throwable cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInstantiateDeploymentAspect$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPropertyNameAttribute = "WFLYWS0032: Could not find property name attribute for deployment aspect: %s";
    protected String missingPropertyNameAttribute$str() {
        return missingPropertyNameAttribute;
    }
    @Override
    public final IllegalStateException missingPropertyNameAttribute(final DeploymentAspect deploymentAspect) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingPropertyNameAttribute$str(), deploymentAspect));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingPropertyClassAttribute = "WFLYWS0033: Could not find property class attribute for deployment aspect: %s";
    protected String missingPropertyClassAttribute$str() {
        return missingPropertyClassAttribute;
    }
    @Override
    public final IllegalStateException missingPropertyClassAttribute(final DeploymentAspect deploymentAspect) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingPropertyClassAttribute$str(), deploymentAspect));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unsupportedPropertyClass = "WFLYWS0034: Unsupported property class: %s";
    protected String unsupportedPropertyClass$str() {
        return unsupportedPropertyClass;
    }
    @Override
    public final IllegalArgumentException unsupportedPropertyClass(final String className) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), unsupportedPropertyClass$str(), className));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateList = "WFLYWS0035: Could not create list of type: %s";
    protected String cannotInstantiateList$str() {
        return cannotInstantiateList;
    }
    @Override
    public final IllegalStateException cannotInstantiateList(final Throwable cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInstantiateList$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateMap = "WFLYWS0036: Could not create map of type: %s";
    protected String cannotInstantiateMap$str() {
        return cannotInstantiateMap;
    }
    @Override
    public final IllegalStateException cannotInstantiateMap(final Throwable cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInstantiateMap$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMetricsAvailable = "WFLYWS0037: No metrics available";
    protected String noMetricsAvailable$str() {
        return noMetricsAvailable;
    }
    @Override
    public final String noMetricsAvailable() {
        return String.format(getLoggingLocale(), noMetricsAvailable$str());
    }
    private static final String cannotFindComponentView = "WFLYWS0038: Cannot find component view: %s";
    protected String cannotFindComponentView$str() {
        return cannotFindComponentView;
    }
    @Override
    public final IllegalStateException cannotFindComponentView(final ServiceName viewName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotFindComponentView$str(), viewName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingChild = "WFLYWS0039: Child '%s' not found for VirtualFile: %s";
    protected String missingChild$str() {
        return missingChild;
    }
    @Override
    public final IOException missingChild(final String child, final VirtualFile file) {
        final IOException result = new IOException(String.format(getLoggingLocale(), missingChild$str(), child, file));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String createContextPhaseFailed = "WFLYWS0040: Failed to create context";
    protected String createContextPhaseFailed$str() {
        return createContextPhaseFailed;
    }
    @Override
    public final Exception createContextPhaseFailed(final Throwable cause) {
        final Exception result = new Exception(String.format(getLoggingLocale(), createContextPhaseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String startContextPhaseFailed = "WFLYWS0041: Failed to start context";
    protected String startContextPhaseFailed$str() {
        return startContextPhaseFailed;
    }
    @Override
    public final Exception startContextPhaseFailed(final Throwable cause) {
        final Exception result = new Exception(String.format(getLoggingLocale(), startContextPhaseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String stopContextPhaseFailed = "WFLYWS0042: Failed to stop context";
    protected String stopContextPhaseFailed$str() {
        return stopContextPhaseFailed;
    }
    @Override
    public final Exception stopContextPhaseFailed(final Throwable cause) {
        final Exception result = new Exception(String.format(getLoggingLocale(), stopContextPhaseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String destroyContextPhaseFailed = "WFLYWS0043: Failed to destroy context";
    protected String destroyContextPhaseFailed$str() {
        return destroyContextPhaseFailed;
    }
    @Override
    public final Exception destroyContextPhaseFailed(final Throwable cause) {
        final Exception result = new Exception(String.format(getLoggingLocale(), destroyContextPhaseFailed$str()), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotInstantiateServletDelegate = "WFLYWS0044: Cannot create servlet delegate: %s";
    protected String cannotInstantiateServletDelegate$str() {
        return cannotInstantiateServletDelegate;
    }
    @Override
    public final IllegalStateException cannotInstantiateServletDelegate(final Throwable cause, final String className) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), cannotInstantiateServletDelegate$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingDeploymentProperty = "WFLYWS0045: Cannot obtain deployment property: %s";
    protected String missingDeploymentProperty$str() {
        return missingDeploymentProperty;
    }
    @Override
    public final IllegalStateException missingDeploymentProperty(final String propertyName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), missingDeploymentProperty$str(), propertyName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleSecurityDomainsDetected = "WFLYWS0046: Multiple security domains not supported. First domain: '%s' second domain: '%s'";
    protected String multipleSecurityDomainsDetected$str() {
        return multipleSecurityDomainsDetected;
    }
    @Override
    public final IllegalStateException multipleSecurityDomainsDetected(final String firstDomain, final String secondDomain) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), multipleSecurityDomainsDetected$str(), firstDomain, secondDomain));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String sameUrlPatternRequested = "WFLYWS0047: Web Service endpoint %s with URL pattern %s is already registered. Web service endpoint %s is requesting the same URL pattern.";
    protected String sameUrlPatternRequested$str() {
        return sameUrlPatternRequested;
    }
    @Override
    public final IllegalArgumentException sameUrlPatternRequested(final String firstClass, final String urlPattern, final String secondClass) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), sameUrlPatternRequested$str(), firstClass, urlPattern, secondClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidServiceRefSetterMethodName = "WFLYWS0048: @WebServiceRef injection target is invalid.  Only setter methods are allowed: %s";
    protected String invalidServiceRefSetterMethodName$str() {
        return invalidServiceRefSetterMethodName;
    }
    @Override
    public final DeploymentUnitProcessingException invalidServiceRefSetterMethodName(final Object o) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidServiceRefSetterMethodName$str(), o));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredServiceRefName = "WFLYWS0049: @WebServiceRef attribute 'name' is required for class level annotations.";
    protected String requiredServiceRefName$str() {
        return requiredServiceRefName;
    }
    @Override
    public final DeploymentUnitProcessingException requiredServiceRefName() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), requiredServiceRefName$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String requiredServiceRefType = "WFLYWS0050: @WebServiceRef attribute 'type' is required for class level annotations.";
    protected String requiredServiceRefType$str() {
        return requiredServiceRefType;
    }
    @Override
    public final DeploymentUnitProcessingException requiredServiceRefType() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), requiredServiceRefType$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConfig = "WFLYWS0051: Config %s doesn't exist";
    protected String missingConfig$str() {
        return missingConfig;
    }
    @Override
    public final OperationFailedException missingConfig(final String configName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), missingConfig$str(), configName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wrongHandlerChainType = "WFLYWS0052: Unsupported handler chain type: %s. Supported types are either %s or %s";
    protected String wrongHandlerChainType$str() {
        return wrongHandlerChainType;
    }
    @Override
    public final StartException wrongHandlerChainType(final String unknownChainType, final String knownChainType1, final String knownChainType2) {
        final StartException result = new StartException(String.format(getLoggingLocale(), wrongHandlerChainType$str(), unknownChainType, knownChainType1, knownChainType2));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingHandlerChain = "WFLYWS0054: Config %s: %s handler chain with id %s doesn't exist";
    protected String missingHandlerChain$str() {
        return missingHandlerChain;
    }
    @Override
    public final OperationFailedException missingHandlerChain(final String configName, final String handlerChainType, final String handlerChainId) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), missingHandlerChain$str(), configName, handlerChainType, handlerChainId));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotGetURLForDescriptor = "WFLYWS0057: Unable to get URL for: %s";
    protected String cannotGetURLForDescriptor$str() {
        return cannotGetURLForDescriptor;
    }
    @Override
    public final DeploymentUnitProcessingException cannotGetURLForDescriptor(final Throwable cause, final String resourcePath) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), cannotGetURLForDescriptor$str(), resourcePath), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jaxRpcNotSupported = "WFLYWS0058: JAX-RPC not supported";
    protected String jaxRpcNotSupported$str() {
        return jaxRpcNotSupported;
    }
    @Override
    public final DeploymentUnitProcessingException jaxRpcNotSupported() {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), jaxRpcNotSupported$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLibraryInDeployment = "WFLYWS0059: %s library (%s) detected in ws endpoint deployment; either provide a proper deployment replacing embedded libraries with container module dependencies or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Java EE and any JBossWS specific functionality to be disabled.";
    protected String invalidLibraryInDeployment$str() {
        return invalidLibraryInDeployment;
    }
    @Override
    public final DeploymentUnitProcessingException invalidLibraryInDeployment(final String libraryName, final String jar) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), invalidLibraryInDeployment$str(), libraryName, jar));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String endpointClassNotFound = "WFLYWS0060: Web service endpoint class %s not found";
    protected String endpointClassNotFound$str() {
        return endpointClassNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException endpointClassNotFound(final String endpointClassName) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), endpointClassNotFound$str(), endpointClassName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String declaredEndpointInterfaceClassNotFound = "WFLYWS0061: The endpointInterface %s declared in the @WebService annotation on web service implementation bean %s was not found.";
    protected String declaredEndpointInterfaceClassNotFound$str() {
        return declaredEndpointInterfaceClassNotFound;
    }
    @Override
    public final DeploymentUnitProcessingException declaredEndpointInterfaceClassNotFound(final String endpointInterface, final Class<?> endpointClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), declaredEndpointInterfaceClassNotFound$str(), endpointInterface, endpointClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String jwsWebServiceClassVerificationFailed = "WFLYWS0062: Class verification of Java Web Service implementation class %s failed.";
    protected String jwsWebServiceClassVerificationFailed$str() {
        return jwsWebServiceClassVerificationFailed;
    }
    @Override
    public final DeploymentUnitProcessingException jwsWebServiceClassVerificationFailed(final Class<?> seiClass) {
        final DeploymentUnitProcessingException result = new DeploymentUnitProcessingException(String.format(getLoggingLocale(), jwsWebServiceClassVerificationFailed$str(), seiClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotUpdateServerConfigBecauseOfReloadRequired = "WFLYWS0063: Could not update WS server configuration because of pending former model update(s) requiring reload.";
    protected String couldNotUpdateServerConfigBecauseOfReloadRequired$str() {
        return couldNotUpdateServerConfigBecauseOfReloadRequired;
    }
    @Override
    public final DisabledOperationException couldNotUpdateServerConfigBecauseOfReloadRequired() {
        final DisabledOperationException result = new DisabledOperationException(String.format(getLoggingLocale(), couldNotUpdateServerConfigBecauseOfReloadRequired$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String couldNotUpdateServerConfigBecauseOfExistingWSDeployment = "WFLYWS0064: Could not update WS server configuration because of existing WS deployment on the server.";
    protected String couldNotUpdateServerConfigBecauseOfExistingWSDeployment$str() {
        return couldNotUpdateServerConfigBecauseOfExistingWSDeployment;
    }
    @Override
    public final DisabledOperationException couldNotUpdateServerConfigBecauseOfExistingWSDeployment() {
        final DisabledOperationException result = new DisabledOperationException(String.format(getLoggingLocale(), couldNotUpdateServerConfigBecauseOfExistingWSDeployment$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void missingModuleDependency(final String annotation, final String clazz, final String module) {
        super.log.logf(FQCN, WARN, null, missingModuleDependency$str(), annotation, clazz, module);
    }
    private static final String missingModuleDependency = "WFLYWS0065: Annotation '@%s' found on class '%s'. Perhaps you forgot to add a '%s' module dependency to your deployment?";
    protected String missingModuleDependency$str() {
        return missingModuleDependency;
    }
    private static final String invalidWSServlet = "WFLYWS0066: Servlet class %s declared in web.xml; either provide a proper deployment relying on JBossWS or disable the webservices subsystem for the current deployment adding a proper jboss-deployment-structure.xml descriptor to it. The former approach is recommended, as the latter approach causes most of the webservices Java EE and any JBossWS specific functionality to be disabled.";
    protected String invalidWSServlet$str() {
        return invalidWSServlet;
    }
    @Override
    public final WSFException invalidWSServlet(final String servletClass) {
        final WSFException result = new WSFException(String.format(getLoggingLocale(), invalidWSServlet$str(), servletClass));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void couldNotActivateSubsystem(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, couldNotActivateSubsystem$str());
    }
    private static final String couldNotActivateSubsystem = "WFLYWS0067: Could not activate the webservices subsystem.";
    protected String couldNotActivateSubsystem$str() {
        return couldNotActivateSubsystem;
    }
    private static final String serviceNotAvailable = "WFLYWS0068: Service %s not available";
    protected String serviceNotAvailable$str() {
        return serviceNotAvailable;
    }
    @Override
    public final OperationFailedException serviceNotAvailable(final String serviceName) {
        final OperationFailedException result = new OperationFailedException(String.format(getLoggingLocale(), serviceNotAvailable$str(), serviceName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void failedAuthorization(final String username) {
        super.log.logf(FQCN, DEBUG, null, failedAuthorization$str(), username);
    }
    private static final String failedAuthorization = "WFLYWS0070: Authorization failed for user: %s";
    protected String failedAuthorization$str() {
        return failedAuthorization;
    }
    @Override
    public final void failedAuthentication(final String username) {
        super.log.logf(FQCN, DEBUG, null, failedAuthentication$str(), username);
    }
    private static final String failedAuthentication = "WFLYWS0071: Failed to authenticate username %s:, incorrect username/password";
    protected String failedAuthentication$str() {
        return failedAuthentication;
    }
    @Override
    public final void failedAuthenticationWithException(final Throwable cause, final String username, final String message) {
        super.log.logf(FQCN, DEBUG, cause, failedAuthenticationWithException$str(), username, message);
    }
    private static final String failedAuthenticationWithException = "WFLYWS0072: Error occured when authenticate username %s. Exception message: %s";
    protected String failedAuthenticationWithException$str() {
        return failedAuthenticationWithException;
    }
    private static final String endpointAlreadyStopped = "WFLYWS0073: The target endpoint %s is undeploying or stopped";
    protected String endpointAlreadyStopped$str() {
        return endpointAlreadyStopped;
    }
    @Override
    public final IllegalStateException endpointAlreadyStopped(final String endpointName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), endpointAlreadyStopped$str(), endpointName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
