/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.service.HandlerChainService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;

final class HandlerChainAdd
extends AbstractAddStepHandler {
    static final HandlerChainAdd INSTANCE = new HandlerChainAdd();

    private HandlerChainAdd() {
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        super.rollbackRuntime(context, operation, resource);
        if (!context.isBooting()) {
            context.revertReloadRequired();
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (context.isBooting()) {
            String protocolBindings = HandlerChainAdd.getAttributeValue(operation, "protocol-bindings");
            PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
            PathElement confElem = address.getElement(address.size() - 2);
            String configType = confElem.getKey();
            String configName = confElem.getValue();
            String handlerChainType = address.getElement(address.size() - 1).getKey();
            String handlerChainId = address.getElement(address.size() - 1).getValue();
            ServiceName configServiceName = PackageUtils.getConfigServiceName(configType, configName);
            if (context.getServiceRegistry(false).getService(configServiceName) == null) {
                throw WSLogger.ROOT_LOGGER.missingConfig(configName);
            }
            ServiceName handlerChainServiceName = PackageUtils.getHandlerChainServiceName(configServiceName, handlerChainType, handlerChainId);
            ServiceTarget target = context.getServiceTarget();
            ServiceBuilder handlerChainServiceBuilder = target.addService(handlerChainServiceName);
            Consumer handlerChainConsumer = handlerChainServiceBuilder.provides(new ServiceName[]{handlerChainServiceName});
            ArrayList<Supplier<UnifiedHandlerMetaData>> handlerSuppliers = new ArrayList<Supplier<UnifiedHandlerMetaData>>();
            for (ServiceName sn : PackageUtils.getServiceNameDependencies(context, handlerChainServiceName, address, "handler")) {
                handlerSuppliers.add(handlerChainServiceBuilder.requires(sn));
            }
            handlerChainServiceBuilder.setInstance((Service)new HandlerChainService(handlerChainType, handlerChainId, protocolBindings, handlerChainConsumer, handlerSuppliers));
            handlerChainServiceBuilder.install();
        } else {
            context.reloadRequired();
        }
    }

    private static String getAttributeValue(ModelNode node, String propertyName) {
        return node.hasDefined(propertyName) ? node.get(propertyName).asString() : null;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.PROTOCOL_BINDINGS.validateAndSet(operation, model);
    }
}

