/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers.deployment;

import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilder;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_EJB;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_JMS;
import org.jboss.as.webservices.deployers.deployment.DeploymentModelBuilderJAXWS_POJO;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.WSAttachmentKeys;
import org.jboss.wsf.spi.metadata.jms.JMSEndpointsMetaData;

public final class WSDeploymentBuilder {
    private static final WSDeploymentBuilder SINGLETON = new WSDeploymentBuilder();
    private static final DeploymentModelBuilder JAXWS_JSE = new DeploymentModelBuilderJAXWS_POJO();
    private static final DeploymentModelBuilder JAXWS_EJB = new DeploymentModelBuilderJAXWS_EJB();
    private static final DeploymentModelBuilder JAXWS_JMS = new DeploymentModelBuilderJAXWS_JMS();

    private WSDeploymentBuilder() {
    }

    public static WSDeploymentBuilder getInstance() {
        return SINGLETON;
    }

    public void build(DeploymentUnit unit) {
        if (WSDeploymentBuilder.isJaxwsPojoDeployment(unit)) {
            WSLogger.ROOT_LOGGER.trace("Detected JAXWS POJO deployment");
            JAXWS_JSE.newDeploymentModel(unit);
        }
        if (WSDeploymentBuilder.isJaxwsJmsDeployment(unit)) {
            WSLogger.ROOT_LOGGER.trace("Detected JAXWS JMS deployment");
            JAXWS_JMS.newDeploymentModel(unit);
        }
        if (WSDeploymentBuilder.isJaxwsEjbDeployment(unit)) {
            WSLogger.ROOT_LOGGER.trace("Detected JAXWS EJB deployment");
            JAXWS_EJB.newDeploymentModel(unit);
        }
    }

    private static boolean isJaxwsPojoDeployment(DeploymentUnit unit) {
        return !ASHelper.getJaxwsPojos(unit).isEmpty();
    }

    private static boolean isJaxwsEjbDeployment(DeploymentUnit unit) {
        return !ASHelper.getJaxwsEjbs(unit).isEmpty();
    }

    private static boolean isJaxwsJmsDeployment(DeploymentUnit unit) {
        JMSEndpointsMetaData jmsEndpointsMD = ASHelper.getOptionalAttachment(unit, WSAttachmentKeys.JMS_ENDPOINT_METADATA_KEY);
        if (jmsEndpointsMD != null) {
            return !jmsEndpointsMD.getEndpointsMetaData().isEmpty();
        }
        return false;
    }
}

