/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.webserviceref;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.FixedInjectionSource;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.ee.utils.InjectionUtils;
import org.jboss.as.ejb3.component.session.SessionBeanComponentDescription;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.as.webservices.webserviceref.WSRefAnnotationWrapper;
import org.jboss.as.webservices.webserviceref.WebServiceReferences;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.modules.Module;

public class WSRefAnnotationProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        List<AnnotationInstance> webServiceRefAnnotations = ASHelper.getAnnotations(unit, DotNames.WEB_SERVICE_REF_ANNOTATION);
        for (AnnotationInstance annotation : webServiceRefAnnotations) {
            AnnotationTarget annotationTarget = annotation.target();
            WSRefAnnotationWrapper annotationWrapper = new WSRefAnnotationWrapper(annotation);
            if (annotationTarget instanceof FieldInfo) {
                WSRefAnnotationProcessor.processFieldRef(unit, annotationWrapper, (FieldInfo)annotationTarget);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                WSRefAnnotationProcessor.processMethodRef(unit, annotationWrapper, (MethodInfo)annotationTarget);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            WSRefAnnotationProcessor.processClassRef(unit, annotationWrapper, (ClassInfo)annotationTarget);
        }
        List<AnnotationInstance> webServiceRefsAnnotations = ASHelper.getAnnotations(unit, DotNames.WEB_SERVICE_REFS_ANNOTATION);
        for (AnnotationInstance outerAnnotation : webServiceRefsAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                WSRefAnnotationWrapper annotationWrapper = new WSRefAnnotationWrapper(annotation);
                WSRefAnnotationProcessor.processClassRef(unit, annotationWrapper, (ClassInfo)annotationTarget);
            }
        }
    }

    public void undeploy(DeploymentUnit unit) {
    }

    private static void processFieldRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, FieldInfo fieldInfo) throws DeploymentUnitProcessingException {
        String fieldName = fieldInfo.name();
        String injectionType = WSRefAnnotationProcessor.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? fieldInfo.type().name().toString() : annotation.type();
        FieldInjectionTarget injectionTarget = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, injectionType);
        String bindingName = WSRefAnnotationProcessor.isEmpty(annotation.name()) ? fieldInfo.declaringClass().name().toString() + "/" + fieldInfo.name() : annotation.name();
        WSRefAnnotationProcessor.processRef(unit, injectionType, annotation, fieldInfo.declaringClass(), (InjectionTarget)injectionTarget, bindingName);
    }

    private static void processMethodRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, MethodInfo methodInfo) throws DeploymentUnitProcessingException {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw WSMessages.MESSAGES.invalidServiceRefSetterMethodName(methodInfo);
        }
        String injectionType = WSRefAnnotationProcessor.isEmpty(annotation.type()) || annotation.type().equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : annotation.type();
        MethodInjectionTarget injectionTarget = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, injectionType);
        String bindingName = WSRefAnnotationProcessor.isEmpty(annotation.name()) ? methodInfo.declaringClass().name().toString() + "/" + methodName.substring(3, 4).toLowerCase(Locale.ENGLISH) + methodName.substring(4) : annotation.name();
        WSRefAnnotationProcessor.processRef(unit, injectionType, annotation, methodInfo.declaringClass(), (InjectionTarget)injectionTarget, bindingName);
    }

    private static void processClassRef(DeploymentUnit unit, WSRefAnnotationWrapper annotation, ClassInfo classInfo) throws DeploymentUnitProcessingException {
        if (WSRefAnnotationProcessor.isEmpty(annotation.name())) {
            throw WSMessages.MESSAGES.requiredServiceRefName();
        }
        if (WSRefAnnotationProcessor.isEmpty(annotation.type())) {
            throw WSMessages.MESSAGES.requiredServiceRefType();
        }
        WSRefAnnotationProcessor.processRef(unit, annotation.type(), annotation, classInfo, null, annotation.name());
    }

    private static void processRef(DeploymentUnit unit, String type, WSRefAnnotationWrapper annotation, ClassInfo classInfo, InjectionTarget injectionTarget, String bindingName) throws DeploymentUnitProcessingException {
        EEModuleDescription moduleDescription = (EEModuleDescription)unit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        AnnotatedElement target = WSRefAnnotationProcessor.createAnnotatedElement(unit, classInfo, injectionTarget);
        String componentClassName = classInfo.name().toString();
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        boolean isEJB = false;
        for (ComponentDescription componentDescription : moduleDescription.getComponentsByClassName(componentClassName)) {
            if (!(componentDescription instanceof SessionBeanComponentDescription)) continue;
            isEJB = true;
            bindingMap.put(componentDescription.getComponentName() + "/" + bindingName, bindingName);
        }
        if (!isEJB) {
            bindingMap.put(bindingName, bindingName);
        }
        for (String refKey : bindingMap.keySet()) {
            String refName = (String)bindingMap.get(refKey);
            ManagedReferenceFactory factory = WebServiceReferences.createWebServiceFactory(unit, type, annotation, target, refName, refKey);
            EEModuleClassDescription classDescription = moduleDescription.addOrGetLocalClassDescription(classInfo.name().toString());
            FixedInjectionSource serviceRefSource = new FixedInjectionSource(factory, (Object)factory);
            BindingConfiguration bindingConfiguration = new BindingConfiguration(refName, (InjectionSource)serviceRefSource);
            classDescription.getBindingConfigurations().add(bindingConfiguration);
            ResourceInjectionConfiguration injectionConfiguration = injectionTarget != null ? new ResourceInjectionConfiguration(injectionTarget, (InjectionSource)new LookupInjectionSource(refName)) : null;
            if (injectionConfiguration == null) continue;
            classDescription.addResourceInjection(injectionConfiguration);
        }
    }

    private static AnnotatedElement createAnnotatedElement(DeploymentUnit unit, ClassInfo classInfo, InjectionTarget injectionTarget) throws DeploymentUnitProcessingException {
        if (injectionTarget == null) {
            return WSRefAnnotationProcessor.elementForInjectionTarget(unit, classInfo);
        }
        return WSRefAnnotationProcessor.elementForInjectionTarget(unit, injectionTarget);
    }

    private static AnnotatedElement elementForInjectionTarget(DeploymentUnit unit, ClassInfo classInfo) throws DeploymentUnitProcessingException {
        DeploymentClassIndex classIndex = (DeploymentClassIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.CLASS_INDEX);
        Class<?> target = WSRefAnnotationProcessor.getClass(classIndex, classInfo.name().toString());
        return target;
    }

    private static AnnotatedElement elementForInjectionTarget(DeploymentUnit unit, InjectionTarget injectionTarget) throws DeploymentUnitProcessingException {
        Module module = (Module)unit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)unit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        String injectionTargetClassName = injectionTarget.getClassName();
        String injectionTargetName = WSRefAnnotationProcessor.getInjectionTargetName(injectionTarget);
        AccessibleObject fieldOrMethod = InjectionUtils.getInjectionTarget((String)injectionTargetClassName, (String)injectionTargetName, (ClassLoader)module.getClassLoader(), (DeploymentReflectionIndex)deploymentReflectionIndex);
        return fieldOrMethod;
    }

    private static String getInjectionTargetName(InjectionTarget injectionTarget) {
        String name = injectionTarget.getName();
        if (injectionTarget instanceof FieldInjectionTarget) {
            return name;
        }
        if (injectionTarget instanceof MethodInjectionTarget) {
            return name.substring(3, 4).toUpperCase(Locale.ENGLISH) + name.substring(4);
        }
        throw new UnsupportedOperationException();
    }

    private static Class<?> getClass(DeploymentClassIndex classIndex, String className) throws DeploymentUnitProcessingException {
        if (!WSRefAnnotationProcessor.isEmpty(className)) {
            try {
                return classIndex.classIndex(className).getModuleClass();
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentUnitProcessingException((Throwable)e);
            }
        }
        return null;
    }

    private static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }
}

