/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.deployers;

import java.util.List;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.ee.structure.DeploymentTypeMarker;
import org.jboss.as.server.deployment.AttachmentList;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.webservices.WSLogger;
import org.jboss.as.webservices.WSMessages;
import org.jboss.as.webservices.util.ASHelper;
import org.jboss.as.webservices.util.DotNames;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;

public class WSLibraryFilterProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit unit = phaseContext.getDeploymentUnit();
        if (DeploymentTypeMarker.isType((DeploymentType)DeploymentType.EAR, (DeploymentUnit)unit)) {
            return;
        }
        CompositeIndex index = (CompositeIndex)unit.getAttachment(Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index != null) {
            AttachmentList resourceRoots;
            if (this.hasWSEndpoints(index) && (resourceRoots = (AttachmentList)unit.getAttachment(Attachments.RESOURCE_ROOTS)) != null) {
                for (ResourceRoot root : resourceRoots) {
                    if (!ASHelper.hasClassesFromPackage((Index)root.getAttachment(Attachments.ANNOTATION_INDEX), "org.apache.cxf")) continue;
                    throw WSMessages.MESSAGES.invalidLibraryInDeployment("Apache CXF", root.getRootName());
                }
            }
        } else {
            WSLogger.ROOT_LOGGER.skippingAnnotationProcessing(unit.getName());
        }
    }

    private boolean hasWSEndpoints(CompositeIndex index) {
        DotName[] dotNames;
        for (DotName dotName : dotNames = new DotName[]{DotNames.WEB_SERVICE_ANNOTATION, DotNames.WEB_SERVICE_PROVIDER_ANNOTATION}) {
            List wsAnnotations = index.getAnnotations(dotName);
            if (wsAnnotations.isEmpty()) continue;
            for (AnnotationInstance wsAnnotation : wsAnnotations) {
                ClassInfo classInfo;
                AnnotationTarget target = wsAnnotation.target();
                if (!(target instanceof ClassInfo) || !ASHelper.isJaxwsEndpoint(classInfo = (ClassInfo)target, index)) continue;
                return true;
            }
        }
        return false;
    }

    public void undeploy(DeploymentUnit unit) {
    }
}

