/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.management.ServerConfig;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;

public final class ConfigService
implements Service<AbstractCommonConfig> {
    private final ServerConfig serverConfig;
    private final String configName;
    private final boolean client;
    private volatile AbstractCommonConfig config;

    public ConfigService(ServerConfig serverConfig, String configName, boolean client) {
        this.configName = configName;
        this.client = client;
        this.serverConfig = serverConfig;
    }

    public AbstractCommonConfig getValue() {
        return this.config;
    }

    public void start(StartContext context) throws StartException {
        if (this.client) {
            ClientConfig clientConfig = new ClientConfig();
            clientConfig.setConfigName(this.configName);
            this.serverConfig.addClientConfig(clientConfig);
            this.config = clientConfig;
        } else {
            EndpointConfig endpointConfig = new EndpointConfig();
            endpointConfig.setConfigName(this.configName);
            this.serverConfig.addEndpointConfig(endpointConfig);
            this.config = endpointConfig;
        }
    }

    public void stop(StopContext context) {
        if (this.client) {
            this.serverConfig.getClientConfigs().remove(this.config);
        } else {
            this.serverConfig.getEndpointConfigs().remove(this.config);
        }
    }
}

